/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.log.aspect;

import cn.tworice.common.util.StringUtils;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.log.annotation.Log;
import cn.tworice.log.dao.po.OperationLogDO;
import cn.tworice.log.service.LogService;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class LogHandleAspect {
    private static final Logger log = LoggerFactory.getLogger(LogHandleAspect.class);
    @Resource
    private LogService logService;

    @Pointcut(value="@annotation(io.swagger.annotations.ApiOperation)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object handle(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return proceedingJoinPoint.proceed();
    }

    @Before(value="pointCut()")
    public void before(JoinPoint joinPoint) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        String adminID = requestAttributes.getRequest().getHeader("adminID");
        if (adminID == null) {
            return;
        }
        try {
            Class<?> clazz = joinPoint.getTarget().getClass();
            if (clazz.getAnnotation(Log.class) != null && clazz.getAnnotation(Log.class).ignore()) {
                return;
            }
            if (clazz.getAnnotation(Api.class) != null) {
                Class<?>[] parameterTypes;
                Api api = clazz.getAnnotation(Api.class);
                if (api.tags() == null || api.tags().length == 0) {
                    return;
                }
                String apiValue = api.tags()[0];
                String methodName = joinPoint.getSignature().getName();
                Method method = clazz.getMethod(methodName, parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes());
                if (method.getAnnotation(GetMapping.class) == null) {
                    Log logAnnotation;
                    ApiOperation operation = method.getAnnotation(ApiOperation.class);
                    String operationValue = operation.value();
                    String log = apiValue + "-" + operationValue;
                    LogHandleAspect.log.info("\u64cd\u4f5c\u65e5\u5fd7\uff1a" + log);
                    OperationLogDO adminLog = new OperationLogDO();
                    adminLog.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    adminLog.setActive(log);
                    adminLog.setUserId(adminID);
                    adminLog.setCreateTime(System.currentTimeMillis());
                    adminLog.setIpAddr(IpAddrUtils.getIpAddr((HttpServletRequest)requestAttributes.getRequest()));
                    if (method.getAnnotation(DeleteMapping.class) != null && clazz.getAnnotation(Log.class) != null && !(logAnnotation = clazz.getAnnotation(Log.class)).ignore() && !StringUtils.isEmpty((String)logAnnotation.table())) {
                        adminLog.setTableName(logAnnotation.table());
                        adminLog.setTargetId(JSON.toJSONString((Object)joinPoint.getArgs()[0]));
                    }
                    this.logService.addAdminLog(adminLog);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private String filter(String target) {
        return target.replace("#", "%23").replace("$", "%24").replace("--", "%2D%2D");
    }
}

