/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.log.web;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.common.vo.StateCodeConst;
import cn.tworice.log.constand.ExportConst;
import cn.tworice.log.dao.po.LoginLogDO;
import cn.tworice.log.dao.po.OperationLogDO;
import cn.tworice.log.service.LogService;
import cn.tworice.mybatis.vo.PageParam;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/log"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u65e5\u5fd7"})
public class LogController {
    private static final Logger log = LoggerFactory.getLogger(LogController.class);
    @Resource
    private LogService logService;

    @GetMapping(value={"adminList"})
    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7")
    public RequestResult adminList(PageParam pageParam, OperationLogDO entity) {
        return RequestResult.success().setData(this.logService.getPage(pageParam, entity));
    }

    @DeleteMapping(value={"delAdmin"})
    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7")
    public RequestResult delAdmin(String[] id) {
        this.logService.removeByIds(Arrays.asList(id));
        return RequestResult.success((String)("\u5220\u9664" + id.length + "\u6761\u64cd\u4f5c\u65e5\u5fd7"));
    }

    @GetMapping(value={"loginList"})
    @ApiOperation(value="\u767b\u5f55\u65e5\u5fd7")
    public RequestResult loginList(PageParam pageParam, LoginLogDO entity) {
        return RequestResult.success().setData(this.logService.getLoginLogPage(pageParam, entity));
    }

    @PutMapping(value={"recover"})
    public RequestResult recover(String id) {
        return RequestResult.success((Integer)StateCodeConst.MESSAGE, (String)this.logService.recover(id));
    }

    @GetMapping(value={"exportOperation"})
    @ApiOperation(value="\u5bfc\u51fa\u64cd\u4f5c\u65e5\u5fd7")
    public void export(Integer type, String[] id, HttpServletResponse response) throws IOException {
        List adminList = null;
        if (ExportConst.ALL.equals(type)) {
            adminList = this.logService.list();
        } else if (id == null || id.length > 0) {
            // empty if block
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u6a21\u677f", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), OperationLogDO.class).sheet("\u64cd\u4f5c\u65e5\u5fd7").doWrite((Collection)adminList);
    }
}

