/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.log.service;

import cn.tworice.common.util.StringUtils;
import cn.tworice.log.dao.LogDao;
import cn.tworice.log.dao.LoginLogDao;
import cn.tworice.log.dao.po.LoginLogDO;
import cn.tworice.log.dao.po.OperationLogDO;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@EnableAsync
@Transactional
public class LogService
extends ServiceImpl<LogDao, OperationLogDO> {
    @Resource
    private LogDao logDao;
    @Resource
    private LoginLogDao loginLogDao;

    @Async
    public void addAdminLog(OperationLogDO log) {
        this.logDao.insert(log);
    }

    public Map<String, Object> getPage(PageParam pageParam, OperationLogDO entity) {
        return this.logDao.selectPage(pageParam, (Wrapper)new MPJLambdaWrapperX().eqIfPresent(OperationLogDO::getUserId, (Object)entity.getUserId()).orderByDesc(OperationLogDO::getCreateTime));
    }

    public Map<String, Object> getLoginLogPage(PageParam pageParam, LoginLogDO entity) {
        return this.loginLogDao.selectPage(pageParam, (Wrapper)new LambdaQueryWrapperX().eqIfPresent(LoginLogDO::getLoginName, (Object)entity.getLoginName()).orderByDesc(LoginLogDO::getCreateTime));
    }

    @Async
    public void addLoginLog(LoginLogDO loginLog) {
        loginLog.setCreateTime(System.currentTimeMillis());
        loginLog.setId(StringUtils.generateUuid());
        this.loginLogDao.insert(loginLog);
    }

    public String recover(String id) {
        OperationLogDO log = (OperationLogDO)this.logDao.selectById((Serializable)((Object)id));
        log.setActive("\u3010\u5df2\u6062\u590d\u3011" + log.getActive());
        if (this.undeleted(log)) {
            log.setTableName(null);
            if (this.logDao.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OperationLogDO::getId, (Object)id)).set(OperationLogDO::getActive, (Object)log.getActive())).set(OperationLogDO::getTableName, (Object)log.getTableName())) == 0) {
                throw new RuntimeException("\u6062\u590d\u5931\u8d25");
            }
            return "\u6062\u590d\u6210\u529f";
        }
        throw new RuntimeException("\u6062\u590d\u5931\u8d25");
    }

    @Deprecated
    @Async
    public void addLoginLog(String username, String password, int i) {
        LoginLogDO log = new LoginLogDO();
        log.setLoginName(username);
        log.setStatus(i);
        log.setPassWord(password);
        log.setCreateTime(System.currentTimeMillis());
        log.setId(StringUtils.generateUuid());
        this.loginLogDao.insert(log);
    }

    @Deprecated
    public void addLoginLog(String username, String password, int i, String ipAddr) {
        LoginLogDO log = new LoginLogDO();
        log.setLoginName(username);
        log.setStatus(i);
        log.setPassWord(password);
        log.setCreateTime(System.currentTimeMillis());
        log.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        log.setIpAddr(ipAddr);
        this.loginLogDao.insert(log);
    }

    private boolean undeleted(OperationLogDO operationLogDO) {
        StringBuilder s = new StringBuilder();
        JSONArray.parseArray((String)operationLogDO.getTargetId()).toJavaList(String.class).forEach(item -> s.append(",'").append((String)item).append("'"));
        return this.logDao.undeleted(operationLogDO.getTableName(), s.substring(1)) > 0;
    }
}

