/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.minio.service;

import cn.tworice.common.util.StringUtils;
import cn.tworice.minio.config.MinioPropertiesConfig;
import cn.tworice.minio.service.MinioService;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.SetBucketPolicyArgs;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MinioServiceImpl
implements MinioService {
    private static final Logger log = LoggerFactory.getLogger(MinioServiceImpl.class);
    @Autowired
    private MinioPropertiesConfig prop;
    @Resource
    private MinioClient minioClient;

    @Override
    public boolean bucketExists(String bucketName) {
        boolean found;
        try {
            found = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return found;
    }

    @Override
    public boolean makeBucket(String bucketName) {
        try {
            if (!this.bucketExists(bucketName)) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
                String policyJson = "{\n\t\"Version\": \"" + new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis()) + "\",\n\t\"Statement\": [{\n\t\t\"Effect\": \"Allow\",\n\t\t\"Principal\": {\n\t\t\t\"AWS\": [\"*\"]\n\t\t},\n\t\t\"Action\": [\"s3:GetBucketLocation\", \"s3:ListBucket\", \"s3:ListBucketMultipartUploads\"],\n\t\t\"Resource\": [\"arn:aws:s3:::" + bucketName + "\"]\n\t}, {\n\t\t\"Effect\": \"Allow\",\n\t\t\"Principal\": {\n\t\t\t\"AWS\": [\"*\"]\n\t\t},\n\t\t\"Action\": [\"s3:AbortMultipartUpload\", \"s3:DeleteObject\", \"s3:GetObject\", \"s3:ListMultipartUploadParts\", \"s3:PutObject\"],\n\t\t\"Resource\": [\"arn:aws:s3:::" + bucketName + "/*\"]\n\t}]\n}\n";
                this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(policyJson).build());
                log.info("buckets\uff1a\u3010{}\u3011,\u521b\u5efa[readwrite]\u7b56\u7565\u6210\u529f\uff01", (Object)bucketName);
            } else {
                log.info("minio bucket->>>\u3010{}\u3011already exists", (Object)bucketName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public List<Bucket> getAllBuckets() {
        try {
            return this.minioClient.listBuckets();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String upload(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (com.alibaba.excel.util.StringUtils.isBlank((CharSequence)originalFilename)) {
            throw new RuntimeException();
        }
        String fileName = StringUtils.generateUuid() + originalFilename.substring(originalFilename.lastIndexOf("."));
        String objectName = this.getNowDateLongStr("yyyy-MM/dd") + "/" + fileName;
        try {
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.prop.getBucketName())).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioClient.putObject(objectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return objectName;
    }

    @Override
    public String upload(MultipartFile file, String bucketName) {
        String originalFilename = file.getOriginalFilename();
        if (com.alibaba.excel.util.StringUtils.isBlank((CharSequence)originalFilename)) {
            throw new RuntimeException();
        }
        String fileName = StringUtils.generateUuid() + originalFilename.substring(originalFilename.lastIndexOf("."));
        String objectName = this.getNowDateLongStr("yyyy-MM/dd") + "/" + fileName;
        try {
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioClient.putObject(objectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return objectName;
    }

    private String getNowDateLongStr(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    @Override
    public String preview(String fileName) {
        new GetPresignedObjectUrlArgs();
        GetPresignedObjectUrlArgs build = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).method(Method.GET).build();
        try {
            String url = this.minioClient.getPresignedObjectUrl(build);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void download(String fileName, HttpServletResponse res) {
        GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).build();
        try (GetObjectResponse response = this.minioClient.getObject(objectArgs);){
            byte[] buf = new byte[1024];
            try (FastByteArrayOutputStream os = new FastByteArrayOutputStream();){
                int len;
                while ((len = response.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                os.flush();
                byte[] bytes = os.toByteArray();
                res.setCharacterEncoding("utf-8");
                res.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                try (ServletOutputStream stream = res.getOutputStream();){
                    stream.write(bytes);
                    stream.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Item> listObjects() {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.prop.getBucketName())).build());
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            for (Result result : results) {
                items.add((Item)result.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return items;
    }

    @Override
    public boolean remove(String fileName) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).build());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

