package cn.tworice.minio.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.minio.config.MinioConfig;
import cn.tworice.minio.config.MinioPropertiesConfig;
import cn.tworice.minio.service.MinioService;
import io.minio.messages.Bucket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Api(tags = "Minio服务")
@Slf4j
@RestController
@RequestMapping(value = "admin/minio")
public class MinioController {

    @Autowired
    private MinioService minioUtil;
    @Autowired
    private MinioPropertiesConfig prop;

    @ApiOperation(value = "查看存储bucket是否存在")
    @GetMapping("/bucketExists")
    public RequestResult bucketExists(@RequestParam("bucketName") String bucketName) {
        return RequestResult.success().appendData("bucketName",minioUtil.bucketExists(bucketName));
    }

    @ApiOperation(value = "创建存储bucket")
    @GetMapping("/makeBucket")
    public RequestResult makeBucket(String bucketName) {
        return RequestResult.success().appendData("bucketName",minioUtil.makeBucket(bucketName));
    }

    @ApiOperation(value = "删除存储bucket")
    @GetMapping("/removeBucket")
    public RequestResult removeBucket(String bucketName) {
        return RequestResult.success().appendData("bucketName",minioUtil.removeBucket(bucketName));
    }

    @ApiOperation(value = "获取全部bucket")
    @GetMapping("/getAllBuckets")
    public RequestResult getAllBuckets() {
        List<Bucket> allBuckets = minioUtil.getAllBuckets();
        return RequestResult.success().appendData("allBuckets",allBuckets);
    }

    @ApiOperation(value = "文件上传返回url")
    @PostMapping("/upload")
    public RequestResult upload(@RequestParam("file") MultipartFile file) {
        String objectName = minioUtil.upload(file);
        if (null != objectName) {
            objectName = "/" + prop.getBucketName() + "/" + objectName; /*  /桶名称/文件名称  */
            return RequestResult.success().appendData("url",(prop.getEndpoint()+ objectName));
        }
        return RequestResult.error();
    }

    @ApiOperation(value = "图片/视频预览")
    @GetMapping("/preview")
    public RequestResult preview(@RequestParam("fileName") String fileName) {
        return RequestResult.success().appendData("fileName",minioUtil.preview(fileName));
    }

    @ApiOperation(value = "文件下载")
    @GetMapping("/download")
    public RequestResult download(@RequestParam("fileName") String fileName, HttpServletResponse res) {
        minioUtil.download(fileName,res);
        return RequestResult.success();
    }

    @ApiOperation(value = "删除文件", notes = "根据url地址删除文件")
    @PostMapping("/delete")
    public RequestResult remove(String url) {
        String objName = url.substring(url.lastIndexOf(prop.getBucketName()+"/") + prop.getBucketName().length()+1);
        minioUtil.remove(objName);
        return RequestResult.success().appendData("objName",objName);
    }
}
