package cn.tworice.minio.service;

import io.minio.messages.Bucket;
import io.minio.messages.Item;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface MinioService {
    /**
     * 查看存储bucket是否存在
     *
     * @param bucketName 存储bucket名称
     * @return boolean
     * @author 二饭 [2022/12/24]
     **/
    boolean bucketExists(String bucketName);

    /**
     * 创建存储bucket
     *
     * @param bucketName 存储bucket名称
     * @return boolean
     * @author 二饭 [2022/12/24]
     **/
    boolean makeBucket(String bucketName);

    /**
     * 删除存储bucket
     *
     * @param bucketName 存储bucket名称
     * @return boolean
     * @author 二饭 [2022/12/24]
     **/
    boolean removeBucket(String bucketName);

    /**
     * 获取全部bucket
     *
     * @return java.util.List<io.minio.messages.Bucket>
     * @author 二饭 [2022/12/24]
     **/
    List<Bucket> getAllBuckets();

    /**
     * 文件上传
     *
     * @param file 文件
     * @return java.lang.String
     * @author 二饭 [2022/12/24]
     **/
    String upload(MultipartFile file);

    /**
     * 文件上传
     *
     * @param file       文件
     * @param bucketName 桶名称
     * @return java.lang.String
     * @author 二饭 [2022/12/24]
     **/
    String upload(MultipartFile file, String bucketName);

    /**
     * 预览图片
     *
     * @param fileName 文件名称
     * @return java.lang.String
     * @author 二饭 [2022/12/24]
     **/
    String preview(String fileName);

    /**
     * 文件下载
     *
     * @param fileName 文件名称
     * @param res      HttpServletResponse对象
     * @author 二饭 [2022/12/24]
     **/
    void download(String fileName, HttpServletResponse res);

    /**
     * 查看文件对象
     *
     * @return java.util.List<io.minio.messages.Item>
     * @author 二饭 [2022/12/24]
     **/
    List<Item> listObjects();

    /**
     * 删除文件
     *
     * @param fileName 文件名称
     * @return boolean
     * @author 二饭 [2022/12/24]
     **/
    boolean remove(String fileName);
}
