/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.monitor.service;

import cn.tworice.common.util.AgingMap;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.monitor.vo.RequestInfo;
import com.alibaba.fastjson.JSON;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RequestFlowService {
    private final ConcurrentLinkedQueue<RequestInfo> queue = new ConcurrentLinkedQueue();
    @Value(value="${tworice.monitor.flow:false}")
    private Boolean flow;
    @Value(value="${tworice.monitor.storage:300}")
    private Integer STORAGE;
    @Value(value="${tworice.monitor.LIMIT:200}")
    private Integer LIMIT;
    @Value(value="${tworice.monitor.refuse:60000}")
    private Long REFUSE;
    private final Map<String, String> sqlMap = new HashMap<String, String>();
    private final AgingMap<String, String> banMap = new AgingMap();
    private static final Pattern SQL_INJECTION_PATTERN = Pattern.compile("(?:\\b(?:select|update|delete|insert|truncate|alter|drop|create|exec|execute|declare|union|merge|call)\\b|\\b(?:--|;|'|\"|\\/\\*|\\*\\/|\\\\x|--|\\/\\*|\\*\\/|\\\\x).*)", 42);

    public boolean enter(HttpServletRequest request) {
        if (!this.flow.booleanValue()) {
            return true;
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setIpAddr(IpAddrUtils.getIpAddr((HttpServletRequest)request));
        if (this.queue.size() > this.STORAGE) {
            this.queue.poll();
        }
        requestInfo.setDate(this.format());
        this.queue.add(requestInfo);
        return this.record(requestInfo);
    }

    public boolean sqlInject(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        if (SQL_INJECTION_PATTERN.matcher(requestPath).find()) {
            return true;
        }
        Iterator iterator = request.getParameterMap().values().iterator();
        while (iterator.hasNext()) {
            String[] paramValues;
            for (String paramValue : paramValues = (String[])iterator.next()) {
                if (paramValue == null || !SQL_INJECTION_PATTERN.matcher(paramValue).find()) continue;
                String ipAddr = IpAddrUtils.getIpAddr((HttpServletRequest)request);
                this.sqlMap.put(ipAddr, paramValue);
                this.banMap.put((Object)ipAddr, null, this.REFUSE.longValue());
                return true;
            }
        }
        return false;
    }

    private boolean record(RequestInfo requestInfo) {
        if (this.banMap.containsKey((Object)requestInfo.getIpAddr())) {
            return false;
        }
        String s = JSON.toJSONString(this.queue);
        String[] split = s.split(requestInfo.getIpAddr());
        if (split.length > this.LIMIT) {
            this.banMap.put((Object)requestInfo.getIpAddr(), (Object)requestInfo.getDate(), this.REFUSE.longValue());
            return false;
        }
        return true;
    }

    private String format() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return hour + ":" + minute;
    }

    public ConcurrentLinkedQueue<RequestInfo> getQueue() {
        return this.queue;
    }

    public Map<String, String> getSqlMap() {
        return this.sqlMap;
    }
}

