package cn.tworice.monitor.vo;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 存储请求信息的实体类
 */
@Data
public class AccessInfo {
    public Long timestamp;          // 请求到达时间
    public String method;           // 请求方法 (GET, POST, etc.)
    public String requestURL;       // 请求 URL（不包含查询字符串）
    public String queryString;      // 查询字符串
    public String protocol;         // 协议及版本
    public String remoteAddr;       // 客户端 IP 地址
    public String remoteHost;       // 客户端主机名
    public int remotePort;          // 客户端端口
    public String serverName;       // 服务器主机名
    public int serverPort;          // 服务器端口
    public Map<String, String> headers = new HashMap<>();      // 请求头（部分关键头）
    public Map<String, String[]> parameters = new HashMap<>(); // 请求参数
}
