/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.monitor.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.monitor.service.MonitorService;
import cn.tworice.monitor.service.RequestFlowService;
import cn.tworice.monitor.vo.RequestInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"admin/monitor"})
@RestController
@CrossOrigin
@Api(tags={"\u76d1\u63a7"})
public class MonitorController {
    @Resource
    private MonitorService monitorService;
    @Resource
    private RequestFlowService requestFlowService;

    @GetMapping(value={"log"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u65e5\u5fd7")
    public RequestResult log() {
        return RequestResult.success().appendData("monitor", this.monitorService.log());
    }

    @GetMapping(value={"operation"})
    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7")
    public RequestResult operation() {
        return RequestResult.success().appendData("monitor", this.monitorService.operation());
    }

    @GetMapping(value={"flow"})
    @ApiOperation(value="\u83b7\u53d6\u8bf7\u6c42\u6d41")
    public RequestResult flow() {
        ConcurrentLinkedQueue<RequestInfo> queue = this.requestFlowService.getQueue();
        LinkedHashMap<String, Integer> ip = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> time = new LinkedHashMap<String, Integer>();
        for (RequestInfo requestInfo : queue) {
            String ipAddr = requestInfo.getIpAddr();
            if (ip.containsKey(ipAddr)) {
                ip.put(ipAddr, (Integer)ip.get(ipAddr) + 1);
            } else {
                ip.put(ipAddr, 1);
            }
            String date = requestInfo.getDate();
            if (time.containsKey(date)) {
                time.put(date, (Integer)time.get(date) + 1);
                continue;
            }
            time.put(date, 1);
        }
        return RequestResult.success().appendData("ip", ip).appendData("time", time);
    }

    @GetMapping(value={"sql"})
    @ApiOperation(value="\u83b7\u53d6SQL\u6ce8\u5165\u653b\u51fb\u8bb0\u5f55")
    public RequestResult sql() {
        return RequestResult.success().appendData("sql", this.requestFlowService.getSqlMap());
    }

    @GetMapping(value={"access"})
    @ApiOperation(value="\u83b7\u53d6\u8bbf\u95ee\u8bb0\u5f55")
    public RequestResult access() {
        return RequestResult.success().appendData("access", this.requestFlowService.getAccessQueue());
    }

    @GetMapping(value={"all"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u76d1\u63a7\u72b6\u6001")
    public RequestResult all() {
        return RequestResult.success().appendData("access", this.requestFlowService.getAccessQueue()).appendData("sql", this.requestFlowService.getSqlMap()).appendData("log", this.monitorService.log()).appendData("operation", this.monitorService.operation());
    }
}

