/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.monitor.service;

import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.AgingMap;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.monitor.config.MonitorProperties;
import cn.tworice.monitor.vo.AccessInfo;
import cn.tworice.monitor.vo.RequestInfo;
import com.alibaba.fastjson.JSON;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class RequestFlowService {
    private final ConcurrentLinkedQueue<RequestInfo> queue = new ConcurrentLinkedQueue();
    @Resource
    private MonitorProperties monitorProperties;
    @Resource
    private MailExecutor mailExecutor;
    private final LinkedList<AccessInfo> accessQueue = new LinkedList();
    private final Map<String, String> sqlMap = new HashMap<String, String>();
    private final AgingMap<String, String> banMap = new AgingMap();
    private static final Pattern SQL_INJECTION_PATTERN = Pattern.compile("(?:\\b(?:select|or|update|delete|insert|truncate|alter|drop|create|exec|execute|declare|union|merge|call)\\b|\\b(?:--|;|'|\"|\\/\\*|\\*\\/|\\\\x|--|\\/\\*|\\*\\/|\\\\x).*)", 42);

    public boolean enter(HttpServletRequest request) {
        if (!this.monitorProperties.getFlow().booleanValue() || Objects.equals(request.getMethod(), "OPTIONS")) {
            return true;
        }
        this.storeRequestInfo(request);
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setIpAddr(IpAddrUtils.getIpAddr((HttpServletRequest)request));
        if (this.queue.size() > this.monitorProperties.getStorage()) {
            this.queue.poll();
        }
        requestInfo.setDate(this.format());
        this.queue.add(requestInfo);
        return this.record(requestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRequestInfo(HttpServletRequest request) {
        String[] headerNames;
        AccessInfo info = new AccessInfo();
        info.timestamp = System.currentTimeMillis();
        info.method = request.getMethod();
        info.requestURL = request.getRequestURL().toString();
        info.queryString = request.getQueryString();
        info.protocol = request.getProtocol();
        info.remoteAddr = request.getRemoteAddr();
        info.remoteHost = request.getRemoteHost();
        info.remotePort = request.getRemotePort();
        info.serverName = request.getServerName();
        info.serverPort = request.getServerPort();
        for (String header : headerNames = new String[]{"User-Agent", "Referer", "Content-Type", "adminId"}) {
            String value = request.getHeader(header);
            if (value == null) continue;
            info.headers.put(header, value);
        }
        info.parameters.putAll(request.getParameterMap());
        LinkedList<AccessInfo> linkedList = this.accessQueue;
        synchronized (linkedList) {
            if (this.accessQueue.size() >= this.monitorProperties.getStorage()) {
                this.accessQueue.removeFirst();
            }
            this.accessQueue.addLast(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<AccessInfo> getAccessQueue() {
        LinkedList<AccessInfo> linkedList = this.accessQueue;
        synchronized (linkedList) {
            return new LinkedList<AccessInfo>(this.accessQueue);
        }
    }

    public boolean sqlInject(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        if (SQL_INJECTION_PATTERN.matcher(requestPath).find()) {
            return true;
        }
        Iterator iterator = request.getParameterMap().values().iterator();
        while (iterator.hasNext()) {
            String[] paramValues;
            for (String paramValue : paramValues = (String[])iterator.next()) {
                if (paramValue == null || !SQL_INJECTION_PATTERN.matcher(paramValue).find()) continue;
                String ipAddr = IpAddrUtils.getIpAddr((HttpServletRequest)request);
                this.sqlMap.put(ipAddr, paramValue);
                this.banMap.put((Object)ipAddr, null, this.monitorProperties.getRefuse().longValue());
                return true;
            }
        }
        return false;
    }

    private boolean record(RequestInfo requestInfo) {
        if (this.banMap.containsKey((Object)requestInfo.getIpAddr())) {
            return false;
        }
        String s = JSON.toJSONString(this.queue);
        String[] split = s.split(requestInfo.getIpAddr());
        if (split.length > this.monitorProperties.getLimit()) {
            this.banMap.put((Object)requestInfo.getIpAddr(), (Object)requestInfo.getDate(), this.monitorProperties.getRefuse().longValue());
            if (this.monitorProperties.getEmail() != null) {
                this.mailExecutor.sendMail(this.monitorProperties.getEmail(), "\u68c0\u6d4b\u5230\u5f02\u5e38\u8bbf\u95ee", "IP\u5730\u5740\uff1a" + requestInfo.getIpAddr() + "\uff0c\u65f6\u95f4\uff1a" + requestInfo.getDate() + "\uff0c\u8bf7\u6c42\u6b21\u6570\uff1a" + split.length + "\uff0c\u5df2\u5c01\u7981" + this.monitorProperties.getRefuse() / 1000L + "\u79d2");
            }
            return false;
        }
        return true;
    }

    private String format() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return hour + ":" + minute;
    }

    public ConcurrentLinkedQueue<RequestInfo> getQueue() {
        return this.queue;
    }

    public Map<String, String> getSqlMap() {
        return this.sqlMap;
    }
}

