/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.mybatis.vo;

import cn.tworice.mybatis.po.SortingField;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Schema(description="\u5206\u9875\u53c2\u6570")
public class PageParam
implements Serializable {
    @Schema(description="\u9875\u7801\uff0c\u4ece 1 \u5f00\u59cb", example="1")
    @NotNull(message="\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=1L, message="\u9875\u7801\u6700\u5c0f\u503c\u4e3a 1")
    private @NotNull(message="\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=1L, message="\u9875\u7801\u6700\u5c0f\u503c\u4e3a 1") Integer page = 1;
    @Schema(description="\u6bcf\u9875\u6761\u6570\uff0c\u6700\u5927\u503c\u4e3a 100", example="10")
    @NotNull(message="\u6bcf\u9875\u6761\u6570\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=1L, message="\u6bcf\u9875\u6761\u6570\u6700\u5c0f\u503c\u4e3a 1")
    @Max(value=100L, message="\u6bcf\u9875\u6761\u6570\u6700\u5927\u503c\u4e3a 100")
    private @NotNull(message="\u6bcf\u9875\u6761\u6570\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=1L, message="\u6bcf\u9875\u6761\u6570\u6700\u5c0f\u503c\u4e3a 1") @Max(value=100L, message="\u6bcf\u9875\u6761\u6570\u6700\u5927\u503c\u4e3a 100") Integer pageSize = 10;

    public static <T> Page<T> buildPage(PageParam pageParam) {
        ArrayList<SortingField> list = new ArrayList<SortingField>();
        return PageParam.buildPage(pageParam, list);
    }

    public static <T> Page<T> buildPage(PageParam pageParam, Collection<SortingField> sortingFields) {
        Page page = new Page((long)pageParam.getPage().intValue(), (long)pageParam.getPageSize().intValue());
        if (sortingFields != null && !sortingFields.isEmpty()) {
            page.addOrder(sortingFields.stream().map(sortingField -> "asc".equals(sortingField.getOrder()) ? OrderItem.asc((String)sortingField.getField()) : OrderItem.desc((String)sortingField.getField())).collect(Collectors.toList()));
        }
        return page;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParam)) {
            return false;
        }
        PageParam other = (PageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    public String toString() {
        return "PageParam(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ")";
    }
}

