package cn.tworice.mybatis.po;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;

@Data
@ExcelIgnoreUnannotated
public class BasicDO implements Serializable {

    @TableField(fill = FieldFill.INSERT)
    private Long createTime; // 添加时间

    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long updateTime; // 更新时间

    @TableLogic(value = "0",delval = "1")
    @ApiModelProperty(value = "是否已删除, 1:是, 0:否")
    private Boolean deleted; // 是否删除标志位

    @TableField(fill = FieldFill.INSERT)
    private String creator;
}
