package cn.tworice.ocr.tess4j.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.ocr.tess4j.service.OCRService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("admin/ocr")
@Slf4j
@CrossOrigin
public class OCRController {

    @Autowired
    private OCRService ocrService;

    @PostMapping("ocr")
    public RequestResult ocr(MultipartFile img){
        return RequestResult.success()
                .appendData("content", ocrService.ocr(img));
    }
}
