/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.ocr.tess4j;

import cn.tworice.ocr.OCRApplication;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.Tesseract;
import net.sourceforge.tess4j.TesseractException;

public class OCRClient {
    private final ITesseract instance = new Tesseract();

    public OCRClient() {
        this.instance.setLanguage("chi_sim");
        this.instance.setOcrEngineMode(1);
    }

    public void setOcrEngineMode(int i) {
        this.instance.setOcrEngineMode(i);
    }

    public void setLanguage(String language) {
        this.instance.setLanguage(language);
    }

    public String ocr(BufferedImage image) throws TesseractException {
        return this.instance.doOCR(image);
    }

    public String ocr(String imgPath) throws IOException, TesseractException {
        BufferedImage image = ImageIO.read(Objects.requireNonNull(OCRApplication.class.getResourceAsStream(imgPath)));
        return this.ocr(image);
    }
}

