/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.ocr.tess4j.service;

import cn.tworice.common.util.file.FileConvertUtil;
import cn.tworice.ocr.exception.OCRException;
import cn.tworice.ocr.tess4j.OCRClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import net.sourceforge.tess4j.TesseractException;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OCRService {
    private OCRClient ocrClient;

    public String ocr(MultipartFile img) throws IOException {
        String fileType = Objects.requireNonNull(img.getOriginalFilename()).substring(img.getOriginalFilename().lastIndexOf(".") + 1);
        if ("png".equals(fileType) || "jpg".equals(fileType)) {
            BufferedImage convert = FileConvertUtil.convert((MultipartFile)img);
            if (this.ocrClient == null) {
                this.ocrClient = new OCRClient();
            }
            try {
                return this.ocrClient.ocr(convert);
            }
            catch (TesseractException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new OCRException("\u8bf7\u4e0a\u4f20\u56fe\u7247");
    }
}

