/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.recommend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Recommender {
    private final Map<String, Map<Integer, Double>> userRatings;
    private final Map<String, Double> userMeans;
    private final Map<String, Set<Integer>> userMovies;

    public Recommender(Map<String, Map<Integer, Double>> userRatings) {
        this.userRatings = userRatings;
        this.userMeans = new HashMap<String, Double>();
        this.userMovies = new HashMap<String, Set<Integer>>();
        for (String userId : userRatings.keySet()) {
            Map<Integer, Double> ratings = userRatings.get(userId);
            double sum = 0.0;
            for (double rating : ratings.values()) {
                sum += rating;
            }
            double mean = sum / (double)ratings.size();
            this.userMeans.put(userId, mean);
            this.userMovies.put(userId, ratings.keySet());
        }
    }

    private double similarity(String userId1, String userId2) {
        Set<Integer> movies1 = this.userMovies.get(userId1);
        if (movies1 == null || movies1.size() == 0) {
            return 0.0;
        }
        Set<Integer> movies2 = this.userMovies.get(userId2);
        HashSet<Integer> commonMovies = new HashSet<Integer>(movies1);
        commonMovies.retainAll(movies2);
        if (commonMovies.isEmpty()) {
            return 0.0;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        Iterator iterator = commonMovies.iterator();
        while (iterator.hasNext()) {
            int movieId = (Integer)iterator.next();
            double rating1 = this.userRatings.get(userId1).get(movieId) - this.userMeans.get(userId1);
            double rating2 = this.userRatings.get(userId2).get(movieId) - this.userMeans.get(userId2);
            sum1 += rating1 * rating2;
            sum2 += rating1 * rating1;
            sum3 += rating2 * rating2;
        }
        double sim = sum1 / Math.sqrt(sum2 * sum3);
        return sim;
    }

    public List<Integer> recommend(String userId, int num) {
        ArrayList<Integer> recommendations = new ArrayList<Integer>();
        HashMap<Integer, Double> scores = new HashMap<Integer, Double>();
        for (String otherUserId : this.userRatings.keySet()) {
            double sim;
            if (otherUserId.equals(userId) || (sim = this.similarity(userId, otherUserId)) <= 0.0) continue;
            Map<Integer, Double> ratings = this.userRatings.get(otherUserId);
            for (int movieId : ratings.keySet()) {
                if (this.userRatings.get(userId).containsKey(movieId)) continue;
                double score = sim * (ratings.get(movieId) - this.userMeans.get(otherUserId));
                if (scores.containsKey(movieId)) {
                    scores.put(movieId, (Double)scores.get(movieId) + score);
                    continue;
                }
                scores.put(movieId, score);
            }
        }
        ArrayList sortedScores = new ArrayList(scores.entrySet());
        Collections.sort(sortedScores, (a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        for (int i = 0; i < Math.min(num, sortedScores.size()); ++i) {
            recommendations.add((Integer)((Map.Entry)sortedScores.get(i)).getKey());
        }
        return recommendations;
    }

    public static void main(String[] args) {
        HashMap<String, Map<Integer, Double>> userRatings = new HashMap<String, Map<Integer, Double>>();
        HashMap<Integer, Double> user1 = new HashMap<Integer, Double>();
        user1.put(1, 3.0);
        user1.put(2, 4.0);
        user1.put(3, 5.0);
        user1.put(4, 3.0);
        HashMap<Integer, Double> user2 = new HashMap<Integer, Double>();
        user2.put(2, 3.0);
        user2.put(3, 4.0);
        user2.put(4, 2.0);
        user2.put(5, 5.0);
        HashMap<Integer, Double> user3 = new HashMap<Integer, Double>();
        user3.put(1, 5.0);
        user3.put(2, 4.0);
        user3.put(4, 2.0);
        user3.put(5, 3.0);
        HashMap<Integer, Double> user4 = new HashMap<Integer, Double>();
        user4.put(1, 4.0);
        user4.put(3, 5.0);
        user4.put(4, 3.0);
        user4.put(5, 4.0);
        HashMap<Integer, Double> user5 = new HashMap<Integer, Double>();
        user5.put(1, 2.0);
        user5.put(3, 3.0);
        user5.put(4, 4.0);
        user5.put(5, 5.0);
        userRatings.put("1", user1);
        userRatings.put("2", user2);
        userRatings.put("3", user3);
        userRatings.put("4", user4);
        userRatings.put("5", user5);
        Recommender recommender = new Recommender(userRatings);
        List<Integer> recommendations = recommender.recommend("1", 3);
        System.out.println(recommendations);
    }
}

