package cn.tworice.swagger.config;

import cn.tworice.swagger.constand.ResponseCode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.*;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.ArrayList;
import java.util.List;

@Configuration
@EnableOpenApi
public class Knife4jConfiguration {

    @Value("${spring.application.name:我的应用}")
    private String applicationName;

    @Bean
    public Docket docketBean() {
        //指定使用Swagger2规范
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(new ApiInfoBuilder()
                        //描述字段支持Markdown语法
                        .description(this.applicationName+"的接口文档")
                        .contact(new Contact("二饭","https://gitee.com/StandFast","1786705138@qq.com"))
                        .version("1.0")
                        .build())
                .groupName(applicationName)
                .select()
                .apis(RequestHandlerSelectors.basePackage("cn.tworice")) // 指定接口扫描包路径
                .paths(PathSelectors.any())
                .build()
                .globalRequestParameters(globalRequestParameters());
    }

    public List<RequestParameter> globalRequestParameters() {
        RequestParameter token = new RequestParameterBuilder()
                .name("token") // 设置header名称
                .in(ParameterType.HEADER) // 设置参数放在哪个地方，这里是header
                .required(true) // 设置是否必须传
                .description("用于验证用户登录的Token")
                .build();
        RequestParameter adminID = new RequestParameterBuilder()
                .name("adminID") // 设置header名称
                .in(ParameterType.HEADER) // 设置参数放在哪个地方，这里是header
                .required(true) // 设置是否必须传
                .description("用户编号")
                .build();
        List<RequestParameter> parameters = new ArrayList<>();
        parameters.add(token);
        parameters.add(adminID);
        return parameters;
    }

    private List<Response> buildResponseMessage(){
        List<Response> responseMessages = new ArrayList<>();
        responseMessages.add(new Response(ResponseCode.SUCCESS_NO_TIPS.getCode().toString(),ResponseCode.SUCCESS_NO_TIPS.getDescription(),true,null,null,null,null));
        responseMessages.add(new Response(ResponseCode.SUCCESS_TIPS.getCode().toString(),ResponseCode.SUCCESS_TIPS.getDescription(),false,null,null,null,null));
        responseMessages.add(new Response(ResponseCode.SUCCESS_CRYPT.getCode().toString(),ResponseCode.SUCCESS_CRYPT.getDescription(),false,null,null,null,null));
        responseMessages.add(new Response(ResponseCode.LOGIN_RE_AUTH.getCode().toString(),ResponseCode.LOGIN_RE_AUTH.getDescription(),false,null,null,null,null));
        responseMessages.add(new Response(ResponseCode.ERROR.getCode().toString(),ResponseCode.ERROR.getDescription(),false,null,null,null,null));
        return responseMessages;
    }
}