//package cn.tworice.swagger.config;
//
//import io.swagger.models.auth.In;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
//import springfox.documentation.builders.ApiInfoBuilder;
//import springfox.documentation.builders.PathSelectors;
//import springfox.documentation.builders.RequestHandlerSelectors;
//import springfox.documentation.service.*;
//import springfox.documentation.spi.DocumentationType;
//import springfox.documentation.spi.service.contexts.SecurityContext;
//import springfox.documentation.spring.web.plugins.Docket;
//
//import java.util.*;
//
///**
// * Swagger配置文件
// * @author 二饭 [2022/9/23]
// **/
//@Configuration
//public class SwaggerConfig implements WebMvcConfigurer {
//
//    @Bean
//    public Docket createRestApi() {
//        return new Docket(DocumentationType.OAS_30).pathMapping("/")
//
//                // 定义是否开启swagger，false为关闭，可以通过变量控制
//                .enable(true)
//
//                // 将api的元信息设置为包含在json ResourceListing响应中。
//                .apiInfo(apiInfo())
//
//                // 接口调试地址
//                .host("http://localhost:88/")
//
//                // 选择哪些接口作为swagger的doc发布
//                .select()
//                .apis(RequestHandlerSelectors.any())
//                .paths(PathSelectors.any())
//                .build()
//
//                // 支持的通讯协议集合
//                .protocols(newHashSet("https", "http"))
//
//                // 授权信息设置，必要的header token等认证信息
//                .securitySchemes(securitySchemes())
//
//                // 授权信息全局应用
//                .securityContexts(securityContexts());
//    }
//    /**
//     * 授权信息全局应用
//     */
//    private List<SecurityContext> securityContexts() {
//        return Collections.singletonList(
//                SecurityContext.builder()
//                        .securityReferences(Collections.singletonList(new SecurityReference("token", new AuthorizationScope[]{new AuthorizationScope("global", "")})))
//                        .build()
//        );
//    }
//
//    /**
//     * 设置授权信息
//     */
//    private List<SecurityScheme> securitySchemes() {
//        ApiKey apiKey = new ApiKey("token", "token", In.HEADER.toValue());
//        return Collections.singletonList(apiKey);
//    }
//
//    @SafeVarargs
//    private final <T> Set<T> newHashSet(T... ts) {
//        if (ts.length > 0) {
//            return new LinkedHashSet<>(Arrays.asList(ts));
//        }
//        return null;
//    }
//
//    private ApiInfo apiInfo() {
//        return new ApiInfoBuilder()
//                // 页面标题1
//                .title("系统接口文档")
//                // 描述
//                .description("系统接口文档").termsOfServiceUrl("#")
//                // 创建人
//                .contact(new Contact("二饭", "https://tworice.cn/", "tworice_0811@163.com"))
//                // 版本号
//                .version("1.0.1").build();
//    }
//}
