package cn.tworice.system.controller.resources;

import cn.tworice.system.dao.resource.po.ResourcesDO;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.service.login.LoginService;
import cn.tworice.system.service.resources.ResourcesService;
import cn.tworice.system.controller.login.constand.SuperAdminConst;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;

@RestController
@RequestMapping("admin/system/resources")
@Slf4j
@CrossOrigin
@Api(tags = "系统菜单资源")
public class ResourcesController {

    @Resource
    private ResourcesService service;

    @Autowired
    private LoginService loginService;

    @ApiOperation("编辑或添加资源")
    @PutMapping("edit")
    @ApiImplicitParam(name = "id", value = "如修改，请添加ID", dataType = "int", dataTypeClass = Integer.class)
    public RequestResult editResources(ResourcesDO resources) {
        if (service.editResource(resources) == 1) {
            return RequestResult.success();
        } else {
            return RequestResult.error();
        }
    }

    @DeleteMapping("del")
    @ApiOperation("删除资源")
    @ApiImplicitParam(name = "ids", value = "资源ID", required = true, dataType = "Array[Integer]", dataTypeClass = Integer[].class)
    public RequestResult delResources(Integer[] ids) {
        return RequestResult.success("删除" + service.delResources(ids) + "条");
    }

    @GetMapping("conditionQuery")
    @ApiOperation("通过条件查询资源内容")
    public RequestResult conditionQueryResources(String name) {
        return RequestResult.success().appendData("list", service.selectResources(name));
    }

    @GetMapping("list")
    @ApiOperation("获取所有资源列表")
    public RequestResult resourcesList() {
        return RequestResult.success().appendData("resourceList", loginService.getResourcesAll(SuperAdminConst.Super_Admin_ID));
    }
}
