package cn.tworice.system.dao.user.po;

import cn.tworice.mybatis.po.BasicDO;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 用户信息实体类
 * @author 二饭[2023年10月25日]
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName(value = "system_user")
public class UserDO extends BasicDO implements Serializable {
    private static final long serialVersionUID = -7332206127189803779L;
    @TableId(type = IdType.ASSIGN_UUID)
    private String id;

    @ExcelProperty("登录账号")
    private String loginName;   // 登录名

    @ExcelProperty("登录密码")
    private String passWord;    // 密码

    @ExcelProperty("姓名")
    private String nickName;    // 昵称

    @ExcelProperty("账号状态（请查看数据字典）")
    private Integer status; // 状态



}
