package cn.tworice.system.service.department;

import cn.tworice.auth.util.LoginUserUtil;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.department.SystemDeployLogDao;
import cn.tworice.system.dao.department.po.SystemDeployLogDO;
import cn.tworice.system.dao.user.po.UserDO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class SystemDeployLogService implements InductsListenerService<SystemDeployLogDO> {
    @Resource
    private SystemDeployLogDao dao;

    public Map<String,Object> list(PageParam pageParam, SystemDeployLogDO entity) {
        return dao.selectPage(pageParam, new MPJLambdaWrapperX<SystemDeployLogDO>()
                .selectAll(SystemDeployLogDO.class)
                .eqIfPresent(SystemDeployLogDO::getId, entity.getId())
                .eqIfPresent(SystemDeployLogDO::getCreator, entity.getCreator())
                .eqIfPresent(SystemDeployLogDO::getUserId,entity.getUserId())
                .eqIfPresent(SystemDeployLogDO::getState,entity.getState())
                .eqIfPresent(SystemDeployLogDO::getDeployId,entity.getDeployId())
                .leftJoin(UserDO.class,UserDO::getId,SystemDeployLogDO::getCreator)
                .select(UserDO::getNickName)
        );
    }

    public int set(SystemDeployLogDO entity) {
        if (entity.getId() == null) {
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    @Override
    public boolean saveBatch(List<SystemDeployLogDO> list) {
        list.forEach(item -> {
            item.setCreator(LoginUserUtil.getLoginUserId());
            item.setCreateTime(System.currentTimeMillis());
            item.setUpdateTime(System.currentTimeMillis());
        });
        return dao.insertBatch(list,list.size());
    }

    public SystemDeployLogDO info(int id) {
        return dao.selectById(id);
    }
}