/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.user;

import cn.tworice.common.util.excel.ExcelUtil;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.conifg.LoginProperties;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.service.user.UserService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"admin/admin"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u8d26\u53f7\u7ba1\u7406"})
@Log(table="system_user")
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Resource
    private UserService service;
    @Resource
    private LoginProperties loginProperties;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u5217\u8868")
    public RequestResult list(PageParam pageParam, UserDO entity) {
        return RequestResult.success().setData(this.service.getPage(pageParam, entity));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u4eba\u5458\u8d26\u53f7")
    public RequestResult add(UserDO user) {
        this.service.updateOrInsert(user);
        return RequestResult.success((String)"\u4eba\u5458\u8d26\u53f7\u66f4\u65b0");
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664\u4eba\u5458\u8d26\u53f7")
    public RequestResult del(@RequestParam(name="ids") String[] ids) {
        this.service.delAdminByIds(ids);
        return RequestResult.success((String)"\u5220\u9664\u8d26\u53f7\u6210\u529f");
    }

    @PutMapping(value={"update"})
    @ApiOperation(value="\u66f4\u65b0\u8d26\u53f7\u5bc6\u7801")
    public RequestResult update(UserDO user) {
        if (this.service.updatePwd(user.getId(), user.getPassWord())) {
            return RequestResult.success().appendData("status", (Object)true);
        }
        return RequestResult.error((String)"\u5bc6\u7801\u66f4\u65b0\u5931\u8d25");
    }

    @PostMapping(value={"inducts"})
    @ApiOperation(value="\u901a\u8fc7Excel\u8868\u683c\u6279\u91cf\u4e0a\u4f20\u6570\u636e")
    public RequestResult inducts(MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, UserDO.class, (ReadListener)new InductsListener((InductsListenerService)this.service)).sheet().doRead();
            return RequestResult.success((String)"\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6210\u529f");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping(value={"template"})
    @ApiOperation(value="\u83b7\u53d6Excel\u6a21\u677f")
    public void template(HttpServletResponse response) throws IOException {
        ExcelUtil.exportExcelTemplate((HttpServletResponse)response, UserDO.class);
    }

    @GetMapping(value={"info"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u6570\u636e")
    public RequestResult info(String id) {
        return RequestResult.success().appendData("info", (Object)this.service.getInfo(id));
    }

    @PutMapping(value={"rePassWord"})
    @ApiOperation(value="\u91cd\u7f6e\u8d26\u6237\u5bc6\u7801")
    public RequestResult rePassWord(@ApiParam(required=true) String id) {
        if (this.service.rePassWord(id)) {
            return RequestResult.success((Integer)201, (String)("\u91cd\u7f6e\u5bc6\u7801\u4e3a\uff1a" + this.loginProperties.getDefaultPassWord()));
        }
        return RequestResult.error((String)"\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25");
    }

    @PutMapping(value={"reBindEmail"})
    @ApiOperation(value="\u6362\u7ed1\u90ae\u7bb1")
    public RequestResult reBindEmail(String newEmail, String authCode) {
        this.service.updateBindEmail(newEmail, authCode);
        return RequestResult.success((Integer)201, (String)"\u5df2\u66f4\u65b0\u8d26\u53f7\u90ae\u7bb1");
    }

    @PostMapping(value={"reEmailCaptcha"})
    @ApiOperation(value="\u83b7\u53d6\u6362\u7ed1\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    public RequestResult reEmailCaptcha(String email) {
        this.service.sendAuthEmail(email);
        return RequestResult.success((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001");
    }
}

