/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.whiteList;

import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.whiteList.po.SystemWhiteListDO;
import cn.tworice.system.service.whiteList.SystemWhiteListService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/whiteList"})
@CrossOrigin
@Log(table="system_white_list")
@Api(tags={"\u8bbf\u95ee\u767d\u540d\u5355\u7ba1\u7406"})
public class SystemWhiteListController {
    @Resource
    private SystemWhiteListService service;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u5217\u8868")
    public RequestResult list(PageParam pageParam, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SystemWhiteListDO entity) {
        return RequestResult.success().setData(this.service.list(pageParam, entity));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public RequestResult add(SystemWhiteListDO entity) {
        this.service.set(entity);
        return RequestResult.success();
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public RequestResult del(@ApiParam(value="\u6570\u636eID\u6570\u7ec4") Integer[] ids) {
        this.service.del(ids);
        return RequestResult.success();
    }

    @PostMapping(value={"inducts"})
    @ApiOperation(value="Excel\u8868\u683c\u6279\u91cf\u4e0a\u4f20\u6570\u636e")
    public RequestResult inducts(@ApiParam(value="Excel\u6587\u4ef6") MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, SystemWhiteListDO.class, (ReadListener)new InductsListener((InductsListenerService)this.service)).sheet().doRead();
            return RequestResult.success((String)"\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6210\u529f");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping(value={"template"})
    @ApiOperation(value="\u5bfc\u51faExcel\u6a21\u677f")
    public void template(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u6a21\u677f", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SystemWhiteListDO.class).sheet("\u6a21\u677f").doWrite(new ArrayList());
    }

    @GetMapping(value={"info"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", (Object)this.service.info(id));
    }
}

