/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.department;

import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.system.dao.department.DepartmentDao;
import cn.tworice.system.dao.department.UserDepartmentDao;
import cn.tworice.system.dao.department.po.DepartmentDO;
import cn.tworice.system.dao.department.po.SystemDeployLogDO;
import cn.tworice.system.dao.department.po.UserDepartmentDO;
import cn.tworice.system.service.department.DepartmentService;
import cn.tworice.system.service.department.SystemDeployLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DepartmentServiceImpl
extends ServiceImpl<DepartmentDao, DepartmentDO>
implements DepartmentService {
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private UserDepartmentDao userDepartmentDao;
    @Resource
    private SystemDeployLogService systemDeployLogService;

    @Override
    public boolean addAdminToDepartment(String[] users, Integer departmentId) {
        Long i = this.userDepartmentDao.selectCount((Wrapper)new LambdaQueryWrapperX().eq(UserDepartmentDO::getDepartmentId, (Object)departmentId).in(UserDepartmentDO::getUserId, Arrays.asList(users)));
        if (i == 0L) {
            this.addLog(users, departmentId, "\u79fb\u5165");
            return this.userDepartmentDao.insertBatch(this.buildUserDepartmentList(users, departmentId));
        }
        return false;
    }

    @Override
    public void delAdminToDepartment(String[] adminIds, Integer departmentId) {
        this.userDepartmentDao.delete((Wrapper)new LambdaQueryWrapperX().in(UserDepartmentDO::getUserId, Arrays.asList(adminIds)).eq(UserDepartmentDO::getDepartmentId, (Object)departmentId));
        this.addLog(adminIds, departmentId, "\u79fb\u51fa");
    }

    @Override
    public boolean delDepartment(List<Integer> departmentIds) {
        if (this.departmentDao.deleteBatchIds(departmentIds) > 0) {
            this.userDepartmentDao.delete((Wrapper)new LambdaQueryWrapperX().in(UserDepartmentDO::getDepartmentId, departmentIds));
            return true;
        }
        return false;
    }

    private void addLog(String[] userId, Integer departmentId, String state) {
        ArrayList<SystemDeployLogDO> list = new ArrayList<SystemDeployLogDO>();
        for (String id : userId) {
            SystemDeployLogDO log = new SystemDeployLogDO();
            log.setUserId(id);
            log.setState(state);
            log.setDeployId(departmentId);
            list.add(log);
        }
        this.systemDeployLogService.saveBatch(list);
    }

    private List<UserDepartmentDO> buildUserDepartmentList(String[] users, Integer departmentId) {
        ArrayList<UserDepartmentDO> list = new ArrayList<UserDepartmentDO>();
        Arrays.stream(users).forEach(item -> list.add(new UserDepartmentDO().setDepartmentId(departmentId).setUserId((String)item)));
        return list;
    }
}

