/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.role;

import cn.tworice.common.util.ArrayUtils;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.system.dao.role.RoleDao;
import cn.tworice.system.dao.role.RoleResourcesDao;
import cn.tworice.system.dao.role.UserRoleDao;
import cn.tworice.system.dao.role.po.RoleDO;
import cn.tworice.system.dao.role.po.RoleResourcesDO;
import cn.tworice.system.dao.role.po.UserRoleDO;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.service.resources.CacheConst;
import cn.tworice.system.service.role.RoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl
extends ServiceImpl<RoleDao, RoleDO>
implements RoleService {
    @Resource
    private RoleDao roleDao;
    @Resource
    private UserRoleDao userRoleDao;
    @Resource
    private RoleResourcesDao roleResourcesDao;

    @Override
    public List<RoleDO> getRoleList() {
        return this.roleDao.selectList((Wrapper)new LambdaQueryWrapperX().orderByAsc(RoleDO::getId));
    }

    @Override
    public List<RoleDO> getRoleListByUid(String userId) {
        return this.roleDao.selectJoinList(RoleDO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().selectAll(RoleDO.class).leftJoin(UserRoleDO.class, UserRoleDO::getRoleId, RoleDO::getId)).eq(UserRoleDO::getUserId, (Object)userId));
    }

    @Override
    public boolean addUserToRole(String[] userIds, Integer roleId) {
        CacheConst.clearRoles(userIds);
        CacheConst.clearResources(userIds);
        if (this.userRoleDao.selectCount((Wrapper)new LambdaQueryWrapperX().eq(UserRoleDO::getRoleId, (Object)roleId).in(UserRoleDO::getUserId, Arrays.asList(userIds))) == 0L) {
            return this.userRoleDao.insertBatch(this.buildUserRoleList(userIds, roleId), userIds.length);
        }
        return false;
    }

    @Override
    public void delAdminToRole(String[] adminIds, Integer roleId) {
        CacheConst.clearRoles(adminIds);
        CacheConst.clearResources(adminIds);
        this.userRoleDao.delete((Wrapper)new LambdaQueryWrapperX().eq(UserRoleDO::getRoleId, (Object)roleId).in(UserRoleDO::getUserId, Arrays.asList(adminIds)));
    }

    @Override
    public List<UserDO> getNoRoleAdmin(int roleId) {
        return this.roleDao.queryNoRoleAdmin(roleId);
    }

    @Override
    public List<RoleResourcesDO> getResourcesByRoleId(Integer roleId) {
        return this.roleResourcesDao.selectList((Wrapper)new LambdaQueryWrapperX().eq(RoleResourcesDO::getRoleId, (Object)roleId));
    }

    @Override
    public Boolean updateRoleResources(Integer[] haveResources, Integer[] updateResources, Integer roleId) {
        CacheConst.RESOURCES.clear();
        ArrayList<Integer> addResources = new ArrayList<Integer>();
        ArrayList<Integer> rmResources = new ArrayList<Integer>();
        for (Integer i : updateResources) {
            if (Arrays.asList(haveResources).contains(i)) continue;
            addResources.add(i);
        }
        for (Integer i : haveResources) {
            if (Arrays.asList(updateResources).contains(i)) continue;
            rmResources.add(i);
        }
        if (!addResources.isEmpty()) {
            this.roleResourcesDao.insertBatch(this.buildRoleRes(addResources, roleId));
        }
        if (!rmResources.isEmpty()) {
            this.roleResourcesDao.delete((Wrapper)new LambdaQueryWrapperX().in(RoleResourcesDO::getResourceId, rmResources).eq(RoleResourcesDO::getRoleId, (Object)roleId));
        }
        return true;
    }

    @Override
    public boolean delRole(List<Integer> roleIdList) {
        CacheConst.ROLES.clear();
        CacheConst.RESOURCES.clear();
        if (this.roleDao.deleteBatchIds(roleIdList) >= 1) {
            this.roleResourcesDao.delete((Wrapper)new LambdaQueryWrapperX().in(RoleResourcesDO::getRoleId, roleIdList));
            this.userRoleDao.delete((Wrapper)new LambdaQueryWrapperX().in(UserRoleDO::getRoleId, roleIdList));
        }
        return true;
    }

    @Override
    public int editRole(Integer roleId, String roleName) {
        int i = roleId < 1 ? this.roleDao.insert(new RoleDO().setRoleName(roleName)) : this.roleDao.updateById(new RoleDO().setId(roleId).setRoleName(roleName));
        return i;
    }

    @Override
    public void setRoleResources(Integer roleId, Integer[] resources) {
        CacheConst.RESOURCES.clear();
        this.roleResourcesDao.delete((Wrapper)new LambdaQueryWrapperX().eq(RoleResourcesDO::getRoleId, (Object)roleId));
        if (ArrayUtils.isNullOrEmpty((Object[])resources)) {
            resources = new Integer[]{};
        }
        this.roleResourcesDao.insertBatch(this.buildRoleRes(Arrays.asList(resources), roleId));
    }

    @Override
    public void delAdminRoleByAdmin(String[] ids) {
        CacheConst.clearRoles(ids);
        CacheConst.clearResources(ids);
        this.userRoleDao.delete((Wrapper)new LambdaQueryWrapperX().in(UserRoleDO::getUserId, Arrays.asList(ids)));
    }

    @Override
    public List<Integer> getRoleIdsByUid(String userId) {
        return this.userRoleDao.selectJoinList(Integer.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().select(new SFunction[]{UserRoleDO::getRoleId}).leftJoin(UserDO.class, UserDO::getId, UserRoleDO::getUserId)).eq(UserRoleDO::getUserId, (Object)userId));
    }

    @Override
    public void removeResourcesInfo(Integer[] ids) {
        this.roleResourcesDao.delete((Wrapper)new LambdaQueryWrapperX().in(RoleResourcesDO::getRoleId, Arrays.asList(ids)));
    }

    private List<UserRoleDO> buildUserRoleList(String[] users, int role) {
        ArrayList<UserRoleDO> userRoles = new ArrayList<UserRoleDO>();
        Arrays.stream(users).forEach(item -> userRoles.add(new UserRoleDO().setUserId((String)item).setRoleId(role)));
        return userRoles;
    }

    private List<RoleResourcesDO> buildRoleRes(List<Integer> resourceIds, Integer roleId) {
        ArrayList<RoleResourcesDO> roleResourcesList = new ArrayList<RoleResourcesDO>();
        resourceIds.forEach(item -> roleResourcesList.add(new RoleResourcesDO().setResourceId((Integer)item).setRoleId(roleId)));
        return roleResourcesList;
    }
}

