package cn.tworice.system.conifg;

import cn.tworice.captcha.constand.CaptchaType;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

@Getter
@Setter
@Component
@ConfigurationProperties(prefix = "tworice.login")
public class LoginProperties {

    /**
     * 验证码有效时间
     */
    private long captchaAging = 300000;

    /**
     * 超级管理员账户
     */
    private String root = "root-root";

    /**
     * Token有效期
     */
    private Long tokenTimeout = 86400000L;

    /**
     * 登录验证码样式
     * 可选{@link cn.tworice.captcha.constand.CaptchaType}
     */
    private String captchaType = CaptchaType.arithmetic;

    /** 是否开启防刷 */
    private Boolean exceeded = true;

    /**
     * 限制数
     */
    private Integer limit = 30;

    /**
     * 是否重复验证，通过二次口令
     */
    private Boolean reAuth = false;

    /**
     * 默认密码
     */
    private String defaultPassWord = "123456";

    /**
     * 默认角色
     */
    private Integer defaultRoleId = 4;

    /**
     * 允许注册的角色
     */
    private List<Integer> allowRole = Arrays.asList(4, 19);
}
