/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.notice;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.notice.po.NoticeDO;
import cn.tworice.system.service.notice.NoticeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/notice"})
@CrossOrigin
@Api(tags={"\u901a\u77e5\u516c\u544a"})
@Log(table="system_notice")
public class NoticeController {
    private static final Logger log = LoggerFactory.getLogger(NoticeController.class);
    @Resource
    private NoticeService service;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u901a\u77e5")
    public RequestResult list(PageParam pageParam, NoticeDO entity) {
        return RequestResult.success().setData(this.service.getPage(pageParam, entity));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u6dfb\u52a0\u901a\u77e5")
    public RequestResult add(NoticeDO notice) {
        this.service.updateOrInsert(notice);
        return RequestResult.success();
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u901a\u8fc7ID\u5220\u9664\u901a\u77e5")
    public RequestResult del(String[] ids) {
        this.service.remove(ids);
        return RequestResult.success((Integer)201, (String)"\u6210\u529f\u5220\u9664");
    }

    @PutMapping(value={"setStatus"})
    @ApiOperation(value="\u8bbe\u7f6e\u901a\u77e5\u7f6e\u9876\u72b6\u6001")
    public RequestResult setStatus(String id, Integer top) {
        this.service.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NoticeDO::getId, (Object)id)).set(NoticeDO::getTop, (Object)top));
        return RequestResult.success();
    }

    @GetMapping(value={"top"})
    @ApiOperation(value="\u83b7\u53d6\u7f6e\u9876\u516c\u544a")
    public RequestResult top() {
        return RequestResult.success().appendData("list", (Object)this.service.list((Wrapper)new LambdaQueryWrapperX().eqIfPresent(NoticeDO::getTop, (Object)1)));
    }

    @GetMapping(value={"info"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u544a\u8be6\u60c5")
    public RequestResult info(String id) {
        return RequestResult.success().appendData("info", (Object)this.service.getInfo(id));
    }
}

