/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.userInfo;

import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.user.po.SystemUserInfoDO;
import cn.tworice.system.service.user.SystemUserInfoService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/adminInfo"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u4eba\u5458\u4fe1\u606f"})
public class SystemUserInfoController {
    @Autowired
    private SystemUserInfoService service;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u83b7\u53d6\u5217\u8868")
    public RequestResult list(PageParam pageParam, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SystemUserInfoDO entity) {
        return RequestResult.success().setData(this.service.getPage(pageParam, entity));
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    public RequestResult add(SystemUserInfoDO entity) {
        if (entity.getId() == null) {
            this.service.save(entity);
        } else {
            this.service.updateById(entity);
        }
        return RequestResult.success();
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u901a\u8fc7ID\u6570\u7ec4\u5220\u9664\u6570\u636e")
    public RequestResult del(@ApiParam(value="\u6570\u636eID\u6570\u7ec4") Integer[] ids) {
        this.service.removeBatchByIds(Arrays.asList(ids));
        return RequestResult.success();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"inducts"})
    @ApiOperation(value="\u901a\u8fc7Excel\u8868\u683c\u6279\u91cf\u4e0a\u4f20\u6570\u636e")
    public RequestResult inducts(@ApiParam(value="Excel\u6587\u4ef6") MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();){
            EasyExcel.read((InputStream)inputStream, SystemUserInfoDO.class, (ReadListener)new InductsListener((InductsListenerService)this.service)).sheet().doRead();
            RequestResult requestResult = RequestResult.success((String)"\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6210\u529f");
            return requestResult;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    @GetMapping(value={"template"})
    @ApiOperation(value="\u83b7\u53d6Excel\u6a21\u677f")
    public void template(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u6a21\u677f", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SystemUserInfoDO.class).sheet("\u6a21\u677f").doWrite(new ArrayList());
    }

    @GetMapping(value={"info/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u6570\u636e")
    public RequestResult info(@PathVariable(value="id") String id) {
        return RequestResult.success().appendData("info", (Object)this.service.info(id));
    }

    @GetMapping(value={"blurInfo/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u8131\u654f\u6570\u636e")
    public RequestResult blurInfo(@PathVariable(value="id") String id) {
        return RequestResult.success().appendData("info", (Object)this.service.blurInfo(id));
    }
}

