/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.feedback;

import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.datatime.TimeUtils;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.mybatis.po.BasicDO;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.controller.feedback.vo.FeedbackStatVO;
import cn.tworice.system.dao.feedback.SystemFeedbackDao;
import cn.tworice.system.dao.feedback.dto.FeedbackDTO;
import cn.tworice.system.dao.feedback.po.SystemFeedbackDO;
import cn.tworice.system.dao.feedback.po.SystemFeedbackTypeDO;
import cn.tworice.system.service.feedback.FeedbackType;
import cn.tworice.system.service.feedback.SystemFeedbackConst;
import cn.tworice.system.service.feedback.SystemFeedbackTypeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SystemFeedbackService
implements InductsListenerService<SystemFeedbackDO> {
    @Resource
    private SystemFeedbackDao dao;
    @Resource
    private MailExecutor mailExecutor;
    @Resource
    private SystemFeedbackTypeService typeService;

    public Map<String, Object> list(PageParam pageParam, SystemFeedbackDO entity) {
        if (entity.getTypeLevel() == null) {
            return this.dao.selectJoinPage(pageParam, FeedbackDTO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().eqIfPresent(SystemFeedbackDO::getId, (Object)entity.getId()).eqIfPresent(BasicDO::getCreator, (Object)entity.getCreator()).eqIfPresent(SystemFeedbackDO::getFbType, (Object)entity.getFbType()).eqIfPresent(SystemFeedbackDO::getFbContact, (Object)entity.getFbContact()).selectAll(SystemFeedbackDO.class).select(new SFunction[]{SystemFeedbackTypeDO::getTypeName}).leftJoin(SystemFeedbackTypeDO.class, SystemFeedbackTypeDO::getId, SystemFeedbackDO::getFbType)).orderByDesc(BasicDO::getCreateTime));
        }
        return this.dao.selectJoinPage(pageParam, FeedbackDTO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().eqIfPresent(SystemFeedbackDO::getId, (Object)entity.getId()).eqIfPresent(BasicDO::getCreator, (Object)entity.getCreator()).eqIfPresent(SystemFeedbackDO::getFbType, (Object)entity.getFbType()).eqIfPresent(SystemFeedbackDO::getFbContact, (Object)entity.getFbContact()).in(SystemFeedbackTypeDO::getTypeLevel, entity.getTypeLevel()).selectAll(SystemFeedbackDO.class).select(new SFunction[]{SystemFeedbackTypeDO::getTypeName}).leftJoin(SystemFeedbackTypeDO.class, SystemFeedbackTypeDO::getId, SystemFeedbackDO::getFbType)).orderByDesc(BasicDO::getCreateTime));
    }

    public int set(SystemFeedbackDO entity) {
        if (entity.getId() == null) {
            return this.dao.insert(entity);
        }
        this.sendMail(entity);
        return this.dao.updateById(entity);
    }

    public int del(Integer[] ids) {
        return this.dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean saveBatch(List<SystemFeedbackDO> list) {
        return this.dao.insertBatch(list, list.size());
    }

    public SystemFeedbackDO info(int id) {
        return (SystemFeedbackDO)this.dao.selectById(Integer.valueOf(id));
    }

    @Deprecated
    public List<Map<String, Object>> getTypeList() {
        ArrayList<Map<String, Object>> typeList = new ArrayList<Map<String, Object>>();
        Arrays.stream(FeedbackType.values()).forEach(item -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", item.getType());
            map.put("msg", item.getMsg());
            typeList.add(map);
        });
        return typeList;
    }

    public RequestResult getStat() {
        ArrayList<FeedbackStatVO> list = new ArrayList<FeedbackStatVO>();
        List<SystemFeedbackTypeDO> typeListByState = this.typeService.getTypeListByState(SystemFeedbackConst.showStateCode);
        for (SystemFeedbackTypeDO typeDO : typeListByState) {
            FeedbackStatVO feedbackStatVO = new FeedbackStatVO();
            long total = this.getTotalByType(typeDO.getId());
            feedbackStatVO.setTotal(total);
            if (total > 0L) {
                feedbackStatVO.setTimeStampCount(TimeUtils.millisecondsToMinutes((long)this.getTimeStampCountByType(typeDO.getId())));
                feedbackStatVO.setTimeStampAvg(TimeUtils.millisecondsToMinutes((long)this.getTimeStampAvgByType(typeDO.getId())));
            } else {
                feedbackStatVO.setTimeStampCount(0L);
                feedbackStatVO.setTimeStampAvg(0L);
            }
            feedbackStatVO.setTypeId(typeDO.getId());
            feedbackStatVO.setTypeLevel(typeDO.getTypeLevel());
            feedbackStatVO.setTypeName(typeDO.getTypeName());
            list.add(feedbackStatVO);
        }
        return RequestResult.success().appendData("list", list);
    }

    private long getTotalByType(int type) {
        return this.dao.selectCount((Wrapper)new MPJLambdaWrapperX().eq(SystemFeedbackDO::getFbType, (Object)type));
    }

    private long getTimeStampCountByType(int type) {
        return this.dao.selectTimeStampCountByType(type);
    }

    private long getTimeStampAvgByType(int type) {
        return this.dao.selectTimeStampAvgByType(type, "\u5df2\u89e3\u51b3");
    }

    private void sendMail(SystemFeedbackDO entity) {
        if ("\u5df2\u89e3\u51b3".equals(entity.getFbState())) {
            this.mailExecutor.sendHtmlMail(entity.getFbContact(), "\u5173\u4e8e\u60a8\u53cd\u9988\u7684\u5185\u5bb9\uff0c\u5f53\u524d\u5904\u7406\u72b6\u6001\u4e3a\uff1a" + entity.getFbState(), entity.getFbDeal());
        }
    }
}

