/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.role;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.role.po.RoleDO;
import cn.tworice.system.service.role.RoleService;
import cn.tworice.system.service.user.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/system/role"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u89d2\u8272"})
@Log(table="system_role")
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Resource
    private RoleService roleService;
    @Resource
    private UserService userService;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    public RequestResult roleList(PageParam pageParam, RoleDO entity) {
        return RequestResult.success().setData(this.roleService.getRoleList(pageParam, entity));
    }

    @GetMapping(value={"adminList"})
    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272ID\u83b7\u53d6\u4eba\u5458\u5217\u8868")
    public RequestResult adminList(PageParam pageParam, Integer roleId) {
        return RequestResult.success().setData(this.userService.getUsersByRole(pageParam, roleId));
    }

    @PutMapping(value={"adminToRole"})
    @ApiOperation(value="\u6dfb\u52a0\u4eba\u5458\u5230\u6307\u5b9a\u89d2\u8272\uff0c\u53ef\u591a\u4eba\u5458")
    public RequestResult addAdminToRole(String[] userId, Integer roleId) {
        if (this.roleService.addUserToRole(userId, roleId)) {
            return RequestResult.success((Integer)201, (String)"\u64cd\u4f5c\u6210\u529f");
        }
        return RequestResult.error((Integer)304, (String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u4eba\u5458\u5230\u89d2\u8272");
    }

    @DeleteMapping(value={"rmAdminToRole"})
    @ApiOperation(value="\u4ece\u89d2\u8272\u79fb\u9664\u4eba\u5458")
    public RequestResult rmAdminToRole(String[] adminIds, Integer roleId) {
        this.roleService.delAdminToRole(adminIds, roleId);
        return RequestResult.success((Integer)201, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"getNoRoleAdmin"})
    @ApiOperation(value="\u83b7\u53d6\u4e0d\u662f\u8be5\u89d2\u8272\u7684\u4eba\u5458")
    public RequestResult getNoRoleAdmin(Integer roleId) {
        return RequestResult.success().appendData("result", this.roleService.getNoRoleAdmin(roleId));
    }

    @GetMapping(value={"getAdminByStatus"})
    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u72b6\u6001\u83b7\u53d6\u4eba\u5458\u5217\u8868\uff0c1-\u6b63\u5e38\uff0c-1-\u975e\u6b63\u5e38")
    public RequestResult getAdminAll(Integer status) {
        return RequestResult.success().appendData("result", this.userService.getUsersByState(status));
    }

    @GetMapping(value={"getResourcesByRoleId"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u8d44\u6e90 \u5173\u8054\u6570\u636e")
    public RequestResult getResourcesByRoleId(Integer roleId) {
        return RequestResult.success().appendData("result", this.roleService.getResourcesByRoleId(roleId));
    }

    @GetMapping(value={"resourcesByRole"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u8d44\u6e90 \u5173\u8054\u6570\u636e")
    public RequestResult resourcesByRole(Integer roleId) {
        return RequestResult.success().appendData("result", this.roleService.getResourcesByRoleId(roleId));
    }

    @PutMapping(value={"updateRoleResources"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u6743\u9650")
    @Deprecated
    public RequestResult updateRoleResources(@ApiParam(value="\u539f\u6709\u8d44\u6e90ID\u6570\u7ec4") Integer[] haveResources, @ApiParam(value="\u66f4\u65b0\u540e\u7684\u8d44\u6e90ID\u6570\u7ec4") Integer[] updateResources, Integer roleId) {
        if (this.roleService.updateRoleResources(haveResources, updateResources, roleId).booleanValue()) {
            RequestResult.success((Integer)201, (String)"\u66f4\u65b0\u6210\u529f");
        }
        return RequestResult.error();
    }

    @PutMapping(value={"updateResources"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u6743\u9650")
    public RequestResult updateResources(@ApiParam(value="\u89d2\u8272ID") Integer roleId, @ApiParam(value="\u66f4\u65b0\u540e\u7684\u8d44\u6e90ID\u6570\u7ec4") Integer[] resourcesId) {
        this.roleService.setRoleResources(roleId, resourcesId);
        return RequestResult.success((Integer)201, (String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"delRole"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    public RequestResult delRole(Integer[] roleId) {
        if (this.roleService.delRole(Arrays.asList(roleId))) {
            return RequestResult.success((Integer)201, (String)"\u5220\u9664\u6210\u529f");
        }
        return RequestResult.error();
    }

    @PutMapping(value={"editRole"})
    @ApiOperation(value="\u7f16\u8f91\u89d2\u8272")
    public RequestResult editRole(Integer roleId, String roleName) {
        if (this.roleService.editRole(roleId, roleName) == 1) {
            return RequestResult.success((Integer)201, (String)"\u4fdd\u5b58\u6210\u529f");
        }
        return RequestResult.error();
    }
}

