/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.whiteList;

import cn.tworice.common.util.RequestUtil;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.whiteList.SystemWhiteListDao;
import cn.tworice.system.dao.whiteList.po.SystemWhiteListDO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class SystemWhiteListService
implements InductsListenerService<SystemWhiteListDO> {
    @Resource
    private SystemWhiteListDao dao;
    public static List<SystemWhiteListDO> cache;

    public boolean ipVerify() {
        String ipAddr = IpAddrUtils.getIpAddr((HttpServletRequest)RequestUtil.getHttpServletRequest());
        if ("127.0.0.1".equals(ipAddr)) {
            return true;
        }
        if (cache == null) {
            cache = this.dao.selectList();
        }
        if (cache.isEmpty()) {
            throw new RuntimeException("\u5f53\u524d\u7cfb\u7edf\u672a\u5141\u8bb8\u4efb\u4f55IP\u8bbf\u95ee");
        }
        for (SystemWhiteListDO whiteList : cache) {
            if (IpAddrUtils.IPToLong((String)whiteList.getBeginIp()) > IpAddrUtils.IPToLong((String)ipAddr) || IpAddrUtils.IPToLong((String)ipAddr) > IpAddrUtils.IPToLong((String)whiteList.getEndIp())) continue;
            return true;
        }
        throw new RuntimeException("\u5f53\u524dIP\u672a\u88ab\u5141\u8bb8\u8bbf\u95ee\u7cfb\u7edf");
    }

    public Map<String, Object> list(PageParam pageParam, SystemWhiteListDO entity) {
        return this.dao.selectPage(pageParam, (Wrapper)new LambdaQueryWrapperX().eqIfPresent(SystemWhiteListDO::getState, (Object)entity.getState()).eqIfPresent(SystemWhiteListDO::getBeginIp, (Object)entity.getBeginIp()).eqIfPresent(SystemWhiteListDO::getEndIp, (Object)entity.getEndIp()));
    }

    public int set(SystemWhiteListDO entity) {
        cache = null;
        entity.setUpdateTime(System.currentTimeMillis());
        if (entity.getId() == null) {
            entity.setCreateTime(System.currentTimeMillis());
            return this.dao.insert(entity);
        }
        return this.dao.updateById(entity);
    }

    public boolean update(SystemWhiteListDO entity) {
        cache = null;
        return this.dao.updateById(entity) == 1;
    }

    public int del(Integer[] ids) {
        cache = null;
        return this.dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean saveBatch(List<SystemWhiteListDO> list) {
        cache = null;
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
            item.setUpdateTime(System.currentTimeMillis());
        });
        return this.dao.insertBatch(list, list.size());
    }

    public SystemWhiteListDO info(int id) {
        return (SystemWhiteListDO)this.dao.selectById(Integer.valueOf(id));
    }
}

