package cn.tworice.system.controller.userInfo;


import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.user.po.SystemUserInfoDO;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.service.user.SystemUserInfoService;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;

@RestController
@RequestMapping("/admin/adminInfo")
@CrossOrigin
@Api(tags = "系统人员信息")
public class SystemUserInfoController {
    @Autowired
    private SystemUserInfoService service;

    @GetMapping("list")
    @ApiOperation("通过条件查询获取列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件")
    SystemUserInfoDO entity) {
        return RequestResult.success()
                .setData(service.getPage(pageParam, entity));
    }

    @PostMapping("add")
    @ApiOperation("新增数据")
    public RequestResult add(SystemUserInfoDO entity) {
        if (entity.getId() == null) {
            service.save(entity);
        }else{
            service.updateById(entity);
        }
        return RequestResult.success();
    }

    @DeleteMapping("del")
    @ApiOperation("通过ID数组删除数据")
    public RequestResult del(@ApiParam("数据ID数组") Integer[] ids) {
        service.removeBatchByIds(Arrays.asList(ids));
        return RequestResult.success();
    }

    @PostMapping("inducts")
    @ApiOperation("通过Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件") MultipartFile file) {
        try (InputStream inputStream = file.getInputStream()){
            EasyExcel.read(inputStream, SystemUserInfoDO.class, new InductsListener(service))
                    .sheet()
                    .doRead();
            return RequestResult.success("批量导入数据成功");
        } catch (Exception ex) {
            throw new RuntimeException("批量导入数据失败");
        }
    }

    /**
     * 导出模板
     * @param response 结果
     * @throws IOException 可能的IO异常
     */
    @GetMapping("template")
    @ApiOperation("获取Excel模板")
    public void template(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("模板", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write(response.getOutputStream(), SystemUserInfoDO.class).sheet("模板")
                .doWrite(new ArrayList<>());
    }

    @GetMapping("info/{id}")
    @ApiOperation("通过ID获取数据")
    public RequestResult info(@PathVariable("id") String id) {
        return RequestResult.success()
                .appendData("info", service.info(id));
    }

    @GetMapping("blurInfo/{id}")
    @ApiOperation("通过ID获取脱敏数据")
    public RequestResult blurInfo(@PathVariable("id") String id) {
        return RequestResult.success().appendData("info", service.blurInfo(id));
    }
}