package cn.tworice.system.controller.whiteList;


import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.whiteList.po.SystemWhiteListDO;
import cn.tworice.system.service.whiteList.SystemWhiteListService;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;

@RestController
@RequestMapping("/admin/whiteList")
@CrossOrigin
@Log(table = "system_white_list")
@Api(tags = "访问白名单管理")
public class SystemWhiteListController {
    @Resource
    private SystemWhiteListService service;

    @GetMapping("list")
    @ApiOperation("获取分页列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件")
                              SystemWhiteListDO entity) {
        return RequestResult.success().setData(service.list(pageParam, entity));
    }

    @PostMapping("add")
    @ApiOperation("新增数据")
    public RequestResult add(SystemWhiteListDO entity) {
        service.set(entity);
        return RequestResult.success();
    }

    @DeleteMapping("del")
    @ApiOperation("删除数据")
    public RequestResult del(@ApiParam("数据ID数组")
                             Integer[] ids) {
        service.del(ids);
        return RequestResult.success();
    }

    @PostMapping("inducts")
    @ApiOperation("Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件")
                                 MultipartFile file) {
        try (InputStream inputStream = file.getInputStream()){
            EasyExcel.read(inputStream, SystemWhiteListDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功");
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /**
     * 导出模板
     * @param response 结果
     * @throws IOException 可能的IO异常
     */
    @GetMapping("template")
    @ApiOperation("导出Excel模板")
    public void template(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel")
        ;
        response.setCharacterEncoding("utf-8")
        ;
        String fileName = URLEncoder.encode("模板", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx")
        ;
        EasyExcel.write(response.getOutputStream(), SystemWhiteListDO.class).sheet("模板")
                .doWrite(new ArrayList<>());
    }

    @GetMapping("info")
    @ApiOperation("获取数据")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", service.info(id));
    }
}