package cn.tworice.system.dao.feedback;

import cn.tworice.mybatis.mapper.BaseMapperX;
import cn.tworice.system.dao.feedback.po.SystemFeedbackDO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

@Repository
public interface SystemFeedbackDao extends BaseMapperX<SystemFeedbackDO> {

    @Select("SELECT SUM(update_time - create_time) AS time_stamp_count FROM system_feedback WHERE fb_type=#{type}")
    Long selectTimeStampCountByType(@Param("type") int type);

    @Select("SELECT AVG(update_time - create_time) AS time_stamp_count FROM system_feedback WHERE fb_type=#{type} AND fb_state=#{state}")
    Long selectTimeStampAvgByType(@Param("type") int type,@Param("state") String state);
}