package cn.tworice.system.dao.login;


import cn.tworice.mybatis.mapper.BaseMapperX;
import cn.tworice.system.dao.resource.po.ResourcesDto;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.dao.role.po.RoleDO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface LoginDao {

    UserDO queryAdmin(String username, String password);

    List<ResourcesDto> queryResourceByRole(List<Integer> roles);

    List<ResourcesDto> queryResourceAll();

    List<ResourcesDto> queryResourceByPid(Integer pid);

    List<Integer> queryRoleId(String userId);

    List<ResourcesDto> queryResourcesByRole(@Param("roles") List<Integer> roles);

    ResourcesDto queryResourcesById(Integer pid);

    List<RoleDO> queryRolesByAdminId(String id);

    UserDO queryAdminByLoginName(String loginName);

    int insertAdmin(UserDO user);

    int insertAdminToRole(String id, int roleId);
}
