package cn.tworice.system.service.resources;

import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.system.dao.resource.po.ResourcesDto;
import cn.tworice.system.dao.resource.po.ResourcesDO;
import cn.tworice.system.dao.resource.ResourcesDao;
import cn.tworice.system.dao.role.RoleResourcesDao;
import cn.tworice.system.dao.role.po.RoleResourcesDO;
import cn.tworice.system.service.role.RoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
@Transactional
public class ResourcesServiceImpl implements ResourcesService {
    @Resource
    private ResourcesDao dao;

    @Resource
    private RoleService roleService;


    @Resource
    private RoleResourcesDao roleResourcesDao;

    /**
     * 添加或更新资源
     * @author 二饭
     */
    @Override
    public int editResource(ResourcesDO resources) {
        CacheConst.RESOURCES.clear();

        int i=0;
        if(resources.getName()==null || resources.getName().isEmpty() || resources.getPid()==null || resources.getSort()==null || resources.getType()==null){
            return i;
        }
        if (resources.getId() == null || resources.getId() == 0) {
            i = dao.insert(resources);
        } else {
            i = dao.updateById(resources);
        }
        return i;
    }

    /**
     * 批量删除资源
     * @author 二饭
     */
    @Override
    public int delResources(Integer[] ids) {
        CacheConst.RESOURCES.clear();

        // TODO 删除权限中的该资源相关信息
        roleService.removeResourcesInfo(ids);
        return dao.deleteBatchIds(Arrays.asList(ids));

    }

    /**
     * 通过条件查询资源
     * @author 二饭
     */
    @Override
    public List<ResourcesDto> selectResources(String name) {
        // TODO 通过资源名称查询资源
//        List<ResourcesDto> list=dao.queryResources(name);
        return null;
    }

    /**
     * 获取叶子节点资源列表
     * @param roles 角色编号列表
     */
    @Override
    public List<ResourcesDto> selectResourcesByRoles(List<Integer> roles) {
        return roleResourcesDao.selectJoinList(ResourcesDto.class, new MPJLambdaWrapperX<RoleResourcesDO>()
                .selectAll(ResourcesDO.class)
                .in(RoleResourcesDO::getRoleId, roles)
                .leftJoin(ResourcesDO.class, ResourcesDO::getId, RoleResourcesDO::getResourceId)
                .eq(ResourcesDO::getState, true)
                .orderByAsc(ResourcesDO::getSort)
        );
    }

    /**
     * 获取所有资源
     * 包括状态为禁用的资源
     */
    @Override
    public List<ResourcesDto> queryResourceAll() {
        return dao.selectJoinList(ResourcesDto.class, new MPJLambdaWrapperX<ResourcesDO>()
                .eq(ResourcesDO::getPid, 0)
                .orderByAsc(ResourcesDO::getSort)
        );

    }

    @Override
    public List<ResourcesDto> selectResourcesByPid(Integer pid) {
        return dao.selectJoinList(ResourcesDto.class, new MPJLambdaWrapperX<ResourcesDO>()
                .selectAll(ResourcesDO.class)
                .eq(ResourcesDO::getPid,pid)
                .orderByAsc(ResourcesDO::getSort)
        );
    }

    @Override
    public ResourcesDto selectResourcesDtoById(Integer id) {
        return dao.selectJoinOne(ResourcesDto.class, new MPJLambdaWrapperX<ResourcesDO>()
                .eq(ResourcesDO::getId, id));
    }
}
