package cn.tworice.system.service.versionLog;

import cn.tworice.system.dao.versionLog.po.VersionLogDO;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.versionLog.VersionLogDao;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class VersionLogService extends ServiceImpl<VersionLogDao, VersionLogDO> implements InductsListenerService<VersionLogDO> {
    @Resource
    private VersionLogDao dao;

    public Map<String,Object> list(PageParam pageParam, VersionLogDO entity) {
        return dao.selectPage(pageParam, new LambdaQueryWrapperX<VersionLogDO>()
                .eqIfPresent(VersionLogDO::getId, entity.getId())
                .eqIfPresent(VersionLogDO::getVersion, entity.getVersion())
                .likeIfPresent(VersionLogDO::getAuthor, entity.getAuthor())
                .orderByDesc(VersionLogDO::getCreateTime)
        );
    }

    public int set(VersionLogDO entity) {
        if (entity.getId() == null) {
            entity.setCreateTime(System.currentTimeMillis());
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean update(VersionLogDO entity) {
        return dao.updateById(entity) == 1;
    }

    @Override
    public boolean saveBatch(List<VersionLogDO> list) {
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
        });
        return dao.insertBatch(list,list.size());
    }

    public VersionLogDO info(int id) {
        return dao.selectById(id);
    }
}