package cn.tworice.system.advice;

import cn.tworice.common.constand.EnvConst;
import cn.tworice.common.vo.RequestResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * RuntimeException全局异常处理器
 * @author 二饭 [2023/1/23]
 **/
@ControllerAdvice
@Slf4j
public class RuntimeExceptionHandler {

    @Value("${tworice.env:prod}")
    private String env;

    @ExceptionHandler(value =RuntimeException.class)
    @ResponseBody
    public RequestResult exceptionHandler(RuntimeException exception){
        if (EnvConst.dev.equals(env)) {
            log.error("全局异常处理器",exception);
        }else{
            log.error(exception.getMessage());
        }
        return RequestResult.error(exception.getMessage());
    }
}
