package cn.tworice.system.controller.login.vo;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class RegVO {
    /**
     * 登录账号
     */
    @NotBlank(message = "登录账号不能为空")
    private String loginName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 密码
     */
    @NotBlank(message = "登录密码不能为空")
    private String passWord;

    /**
     * 称呼
     */
    @NotBlank(message = "称呼不能为空")
    private String nickName;

    /**
     * 验证码的KEY
     */
    @NotBlank(message = "验证码的KEY不能为空")
    private String key;

    /**
     * 用户输入的验证码
     */
    @NotBlank(message = "验证码不能为空")
    private String captcha;

    /**
     * 注册的角色ID
     */
    private Integer roleId;

    /**
     * 邀请码
     */
    private String invitationCode;

    /**
     * 注册方式
     */
    private RegModelEnum regModel = RegModelEnum.EMAIL;
}
