/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.department;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.system.dao.department.po.DepartmentDO;
import cn.tworice.system.service.department.DepartmentService;
import cn.tworice.system.service.user.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/system/department"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u90e8\u95e8"})
@Log(table="system_department")
public class DepartmentController {
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Autowired
    private DepartmentService departmentService;
    @Resource
    private UserService userService;

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u5217\u8868")
    public RequestResult departmentList() {
        return RequestResult.success().appendData("departmentList", (Object)this.departmentService.list());
    }

    @GetMapping(value={"adminList"})
    @ApiOperation(value="\u901a\u8fc7\u90e8\u95e8ID\u83b7\u53d6\u4eba\u5458\u5217\u8868")
    public RequestResult adminList(Integer departmentId) {
        return RequestResult.success().appendData("adminList", this.userService.getUsersByDepartmentId(departmentId));
    }

    @PutMapping(value={"adminToDepartment"})
    @ApiOperation(value="\u6dfb\u52a0\u4eba\u5458\u5230\u6307\u5b9a\u90e8\u95e8")
    public RequestResult addAdminToDepartment(String[] userId, Integer departmentId) {
        if (this.departmentService.addAdminToDepartment(userId, departmentId)) {
            return RequestResult.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return RequestResult.error((String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u4eba\u5458\u5230\u90e8\u95e8");
    }

    @DeleteMapping(value={"rmAdminToDepartment"})
    @ApiOperation(value="\u4ece\u90e8\u95e8\u79fb\u9664\u4eba\u5458")
    public RequestResult rmAdminToDepartment(String[] adminIds, Integer departmentId) {
        this.departmentService.delAdminToDepartment(adminIds, departmentId);
        return RequestResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"getNoDepartmentAdmin"})
    @ApiOperation(value="\u83b7\u53d6\u4e0d\u662f\u8be5\u90e8\u95e8\u7684\u4eba\u5458")
    public RequestResult getNoDepartmentAdmin(Integer departmentId) {
        return RequestResult.success().appendData("result", this.userService.getUsersByNoDepartmentId(departmentId));
    }

    @GetMapping(value={"getAdminByStatus"})
    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u72b6\u6001\u83b7\u53d6\u4eba\u5458\u5217\u8868\uff0c0-\u6b63\u5e38\uff0c1-\u975e\u6b63\u5e38")
    public RequestResult getAdminAll(Integer status) {
        return RequestResult.success().appendData("result", this.userService.getUsersByState(status));
    }

    @DeleteMapping(value={"delDepartment"})
    @ApiOperation(value="\u5220\u9664\u90e8\u95e8")
    public RequestResult delDepartment(Integer[] departmentId) {
        boolean b = this.departmentService.delDepartment(Arrays.asList(departmentId));
        if (b) {
            return RequestResult.success((String)"\u5220\u9664\u6210\u529f").appendData("departmentList", (Object)this.departmentService.list());
        }
        return RequestResult.error();
    }

    @PutMapping(value={"editDepartment"})
    @ApiOperation(value="\u7f16\u8f91\u90e8\u95e8")
    public RequestResult editDepartment(Integer departmentId, String departmentName) {
        if (departmentId == null || departmentId < 1) {
            this.departmentService.save(new DepartmentDO().setDepartmentName(departmentName));
        } else {
            this.departmentService.updateById(new DepartmentDO().setId(departmentId).setDepartmentName(departmentName));
        }
        return RequestResult.success((String)"\u4fdd\u5b58\u6210\u529f").appendData("departmentList", (Object)this.departmentService.list());
    }
}

