/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.login;

import cn.tworice.auth.service.AuthManager;
import cn.tworice.captcha.core.CaptchaBase64;
import cn.tworice.common.annotation.NoEncryption;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.system.controller.login.vo.LoginVO;
import cn.tworice.system.controller.login.vo.RegVO;
import cn.tworice.system.service.login.LoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/login"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u767b\u5f55"})
@Log(ignore=true)
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private LoginService loginService;
    @Resource
    private AuthManager authManager;

    @ApiOperation(value="\u767b\u5f55")
    @PostMapping
    public RequestResult login(LoginVO loginVO, HttpServletRequest request, HttpServletResponse response) {
        if (this.authManager.auth(request, response)) {
            return this.loginService.checkLogin(loginVO, request);
        }
        return RequestResult.error((String)"\u767b\u5f55\u5931\u8d25");
    }

    @ApiOperation(value="\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55")
    @PostMapping(value={"emailLogin"})
    public RequestResult emailLogin(LoginVO loginVO, HttpServletRequest request, HttpServletResponse response) {
        if (this.authManager.auth(request, response)) {
            return this.loginService.checkMailCaptchaLogin(loginVO, request);
        }
        return RequestResult.error((String)"\u767b\u5f55\u5931\u8d25");
    }

    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @PostMapping(value={"emailCaptcha"})
    public RequestResult emailCaptcha(String email) {
        this.loginService.getCaptcha(email);
        return RequestResult.success();
    }

    @ApiOperation(value="\u4e8c\u6b21\u9a8c\u8bc1\u767b\u5f55")
    @PostMapping(value={"reAuth"})
    public RequestResult login(String key, String varCode, HttpServletRequest request) {
        return this.loginService.checkLogin(key, varCode, request);
    }

    @ApiOperation(value="\u91cd\u65b0\u53d1\u9001\u4e8c\u6b21\u767b\u5f55\u9a8c\u8bc1\u7801")
    @PostMapping(value={"sendReAuthCaptcha"})
    public RequestResult sendReAuthCaptcha(String key) {
        this.loginService.sendReAuthCaptcha(key);
        return RequestResult.success();
    }

    @GetMapping(value={"captcha"})
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801\u56fe\u7247")
    @NoEncryption
    public RequestResult captcha(String code) {
        CaptchaBase64 captcha = this.loginService.getLoginCaptcha(code);
        return RequestResult.success().appendData("captcha", (Object)captcha.getCaptcha()).appendData("key", (Object)captcha.getKey());
    }

    @GetMapping(value={"regCaptcha"})
    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    public RequestResult regCaptcha(String email) {
        return RequestResult.success((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001").appendData("key", (Object)this.loginService.getRegCaptcha(email));
    }

    @PostMapping(value={"reg"})
    @ApiOperation(value="\u6ce8\u518c\u8d26\u53f7\u4fe1\u606f")
    public RequestResult reg(RegVO regVO) {
        return RequestResult.success((String)this.loginService.checkReg(regVO));
    }
}

