/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.system;

import cn.tworice.auth.service.VerifyManger;
import cn.tworice.common.util.SystemInfoUtil;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.service.system.SystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/system"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u5de5\u5177"})
public class SystemController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private VerifyManger verifyManger;
    @Resource
    private SystemService systemService;
    @Value(value="${tworice.dev:false}")
    private Boolean devState;

    @GetMapping(value={"online"})
    public RequestResult online() {
        return RequestResult.success().appendData("list", (Object)this.verifyManger.onlineMap());
    }

    @DeleteMapping(value={"offline"})
    public RequestResult offline(String key) {
        this.verifyManger.offline(key);
        return RequestResult.success();
    }

    @GetMapping(value={"systemInfo"})
    public RequestResult systemInfo() {
        SystemInfoUtil systemInfoUtil = new SystemInfoUtil();
        return RequestResult.success().appendData("systemInfo", (Object)systemInfoUtil.getSystemInfo()).appendData("memoryInfo", (Object)systemInfoUtil.getMemoryInfo()).appendData("processInfo", (Object)systemInfoUtil.getProcessInfo()).appendData("cpuInfo", (Object)systemInfoUtil.getCpuInfo());
    }

    @GetMapping(value={"recovery"})
    @ApiOperation(value="\u7cfb\u7edf\u6062\u590d")
    public RequestResult recovery() throws UnsupportedEncodingException {
        if (!this.devState.booleanValue()) {
            return RequestResult.error((String)"\u7cfb\u7edf\u5f53\u524d\u4e0d\u652f\u6301\u521d\u59cb\u5316");
        }
        this.systemService.recoveryBySQLResource();
        return RequestResult.success((String)"\u7cfb\u7edf\u5df2\u7ecf\u521d\u59cb\u5316");
    }
}

