/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.user;

import cn.tworice.auth.util.LoginUserUtil;
import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.AgingMap;
import cn.tworice.common.util.MathUtils;
import cn.tworice.common.util.StringUtils;
import cn.tworice.common.util.cryption.MD5Utils;
import cn.tworice.mybatis.po.BasicDO;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.conifg.LoginProperties;
import cn.tworice.system.dao.department.po.UserDepartmentDO;
import cn.tworice.system.dao.role.po.UserRoleDO;
import cn.tworice.system.dao.user.UserDao;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.service.login.LoginService;
import cn.tworice.system.service.role.RoleService;
import cn.tworice.system.service.user.SystemUserInfoService;
import cn.tworice.system.service.user.UserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends ServiceImpl<UserDao, UserDO>
implements UserService {
    @Resource
    private UserDao dao;
    @Resource
    private RoleService roleService;
    @Resource
    private SystemUserInfoService adminInfoService;
    @Resource
    private LoginService loginService;
    @Resource
    private MailExecutor mailExecutor;
    @Resource
    private LoginProperties loginProperties;
    private final AgingMap<String, String> reEmail = new AgingMap(Integer.valueOf(10));

    @Override
    public Map<String, Object> getPage(PageParam pageParam, UserDO entity) {
        return this.dao.selectPage(pageParam, (Wrapper)new LambdaQueryWrapperX().eqIfPresent(UserDO::getId, (Object)entity.getId()).likeIfPresent(UserDO::getLoginName, entity.getLoginName()).likeIfPresent(UserDO::getNickName, entity.getNickName()).orderByDesc(BasicDO::getCreateTime));
    }

    @Override
    public String updateOrInsert(UserDO user) {
        String id = null;
        if (StringUtils.isBlank((String)user.getId())) {
            user.setPassWord(MD5Utils.getMd5Plus((String)(user.getPassWord() == null ? this.loginProperties.getDefaultPassWord() : user.getPassWord())));
            this.dao.insert(user);
        } else {
            this.updateById(user);
            id = user.getId();
        }
        return id;
    }

    @Override
    public void delAdminByIds(String[] ids) {
        this.dao.deleteBatchIds(Arrays.asList(ids));
        this.roleService.delAdminRoleByAdmin(ids);
        this.adminInfoService.removeByAdminId(ids);
    }

    @Override
    public boolean updatePwd(String id, String pwd) {
        if (this.dao.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserDO::getId, (Object)id)).set(UserDO::getPassWord, (Object)MD5Utils.getMd5Plus((String)pwd))) != 1) {
            throw new RuntimeException("\u66f4\u65b0\u8d26\u53f7\u4fe1\u606f\u5f02\u5e38");
        }
        return true;
    }

    @Override
    public UserDO getInfo(String id) {
        return (UserDO)this.dao.selectById((Serializable)((Object)id));
    }

    @Override
    public boolean rePassWord(String id) {
        return this.updatePwd(id, this.loginProperties.getDefaultPassWord());
    }

    @Override
    public Map<String, Object> getUsersByRole(PageParam pageParam, Integer roleId) {
        return this.dao.selectJoinPage(pageParam, UserDO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().selectAll(UserDO.class).leftJoin(UserRoleDO.class, UserRoleDO::getUserId, UserDO::getId)).eq(UserRoleDO::getRoleId, (Object)roleId));
    }

    @Override
    public List<UserDO> getUsersByDepartmentId(Integer departmentId) {
        return this.dao.selectJoinList(UserDO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().leftJoin(UserDepartmentDO.class, UserDepartmentDO::getUserId, UserDO::getId)).eq(UserDepartmentDO::getDepartmentId, (Object)departmentId));
    }

    @Override
    public List<UserDO> getUsersByNoDepartmentId(Integer departmentId) {
        return this.dao.selectList((Wrapper)new MPJLambdaWrapperX().select(new SFunction[]{UserDO::getId, UserDO::getLoginName, UserDO::getNickName}).notInSql(UserDO::getId, "SELECT user_id FROM system_user_department WHERE deleted = 0 AND department_id <> " + departmentId));
    }

    @Override
    public List<UserDO> getUsersByState(Integer status) {
        return this.dao.selectList((Wrapper)new LambdaQueryWrapperX().select(new SFunction[]{UserDO::getId, UserDO::getLoginName, UserDO::getNickName, UserDO::getStatus}).eq(UserDO::getStatus, (Object)status));
    }

    @Override
    public UserDO getUserByEmailAndPwd(String email, String password) {
        return (UserDO)this.dao.selectOne(UserDO::getEmail, email, UserDO::getPassWord, MD5Utils.getMd5Plus((String)password));
    }

    @Override
    public UserDO getUser(String loginName) {
        return (UserDO)this.dao.selectOne(UserDO::getLoginName, loginName);
    }

    @Override
    public void updateBindEmail(String newEmail, String authCode) {
        if (this.loginService.getUserByLoginName(newEmail) != null) {
            throw new RuntimeException("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u4f7f\u7528");
        }
        if (!this.authReEmailCode(newEmail, authCode)) {
            throw new RuntimeException("\u90ae\u7bb1\u9a8c\u8bc1\u5931\u8d25");
        }
        this.updateUserEmail(LoginUserUtil.getLoginUserId(), newEmail);
    }

    @Override
    public void sendAuthEmail(String email) {
        this.reEmail.put((Object)email, (Object)this.mailExecutor.sendEmailCaptcha(4, email, "\u6362\u7ed1\u90ae\u7bb1"), this.loginProperties.getCaptchaAging());
    }

    @Override
    public synchronized String getInviteCode() {
        UserDO userDO = (UserDO)this.dao.selectById((Serializable)((Object)LoginUserUtil.getLoginUserId()));
        if (userDO.getInviteCode() == null) {
            return this.buildInviteCode(userDO);
        }
        return userDO.getInviteCode();
    }

    @Override
    public String getUserIdByInviteCode(String inviteCode) {
        if (inviteCode == null) {
            return null;
        }
        return Optional.ofNullable(this.dao.selectOne((Wrapper)new LambdaQueryWrapperX().select(new SFunction[]{UserDO::getId}).eq(UserDO::getInviteCode, (Object)inviteCode))).map(UserDO::getId).orElse(null);
    }

    @Override
    public Map<String, Object> getUsersByInviterId(PageParam pageParam, String inviterId) {
        return this.dao.selectPage(pageParam, (Wrapper)new LambdaQueryWrapperX().eq(UserDO::getInviterId, (Object)inviterId).select(new SFunction[]{UserDO::getId, UserDO::getLoginName, UserDO::getNickName, UserDO::getStatus}));
    }

    @Override
    public UserDO existUserByEmail(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        return (UserDO)this.dao.selectOne(UserDO::getEmail, email);
    }

    @Override
    public UserDO existUserByPhone(String phone) {
        if (StringUtils.isEmpty((String)phone)) {
            return null;
        }
        return (UserDO)this.dao.selectOne(UserDO::getPhone, phone);
    }

    @Override
    public void editLoginName(String id, String loginName) {
        if (StringUtils.isEmpty((String)id)) {
            throw new RuntimeException("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserDO userDO = (UserDO)this.dao.selectOne((Wrapper)new LambdaQueryWrapperX().eq(UserDO::getLoginName, (Object)loginName));
        if (userDO != null) {
            throw new RuntimeException("\u767b\u5f55\u8d26\u53f7\u5df2\u88ab\u4f7f\u7528");
        }
        this.dao.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserDO::getId, (Object)id)).set(UserDO::getLoginName, (Object)loginName));
    }

    @Override
    public UserDO getUserByNameAndPwd(String loginName, String password) {
        return (UserDO)this.dao.selectOne(UserDO::getLoginName, loginName, UserDO::getPassWord, MD5Utils.getMd5Plus((String)password));
    }

    @Override
    public UserDO getUserByPhoneAndPwd(String phone, String password) {
        return (UserDO)this.dao.selectOne(UserDO::getPhone, phone, UserDO::getPassWord, MD5Utils.getMd5Plus((String)password));
    }

    @Override
    public UserDO getUserByIDAndPwd(String id, String password) {
        return (UserDO)this.dao.selectOne(UserDO::getId, id, UserDO::getPassWord, MD5Utils.getMd5Plus((String)password));
    }

    public boolean saveBatch(List<UserDO> list) {
        list.forEach(item -> {
            item.setId(StringUtils.generateUuid());
            item.setPassWord(MD5Utils.getMd5Plus((String)item.getPassWord()));
        });
        return this.dao.insertBatch(list, list.size());
    }

    private void updateUserEmail(String uid, String newEmail) {
        UserDO userDO = new UserDO();
        userDO.setId(uid);
        userDO.setLoginName(newEmail);
        this.dao.updateById(userDO);
    }

    private boolean authReEmailCode(String email, String code) {
        return this.reEmail.exist((Object)email, (Object)code);
    }

    private String buildInviteCode(UserDO userDO) {
        String inviteCode = MathUtils.getRandomNumber((int)6);
        String userId = this.getUserIdByInviteCode(inviteCode);
        if (userId == null) {
            userDO.setInviteCode(inviteCode);
            this.dao.updateById(userDO);
            return inviteCode;
        }
        return this.buildInviteCode(userDO);
    }
}

