package cn.tworice.system.controller.notice;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.notice.po.NoticeDO;
import cn.tworice.system.service.notice.NoticeService;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Arrays;


@RestController
@RequestMapping("admin/notice")
@Slf4j
@CrossOrigin
@Api(tags = "通知公告")
@Log(table = "system_notice")
public class NoticeController {

    @Resource
    private NoticeService service;

    /**
     * 获取所有通知
     *
     */
    @GetMapping("list")
    @ApiOperation("获取所有通知")
    public RequestResult list(PageParam pageParam, NoticeDO entity) {
        return RequestResult.success()
                .setData(service.getPage(pageParam, entity));
    }

    /**
     * 添加通知
     */
    @PostMapping("add")
    @ApiOperation("添加通知")
    public RequestResult add(NoticeDO notice) {
        service.updateOrInsert(notice);
        return RequestResult.success();
    }


    @DeleteMapping("del")
    @ApiOperation("通过ID删除通知")
    public RequestResult del(String[] ids) {
        service.remove(ids);
        return RequestResult.success(201, "成功删除");
    }

    @PutMapping("setStatus")
    @ApiOperation("设置通知置顶状态")
    public RequestResult setStatus(String id, Integer top) {
        service.update(new LambdaUpdateWrapper<NoticeDO>()
                .eq(NoticeDO::getId, id)
                .set(NoticeDO::getTop, top)
        );
        return RequestResult.success();
    }

    @GetMapping("top")
    @ApiOperation("获取置顶公告")
    public RequestResult top(){
        return RequestResult.success()
                .appendData("list", service.list(new LambdaQueryWrapperX<NoticeDO>()
                        .eqIfPresent(NoticeDO::getTop, 1)));
    }

    @GetMapping("info")
    @ApiOperation("获取公告详情")
    public RequestResult info(String id){
        return RequestResult.success()
                .appendData("info", service.getInfo(id));
    }
}