package cn.tworice.system.dao.resource.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 资源表，存放所有资源信息
 */
@Data
@TableName("system_resources")
public class ResourcesDO implements Serializable {
    private static final long serialVersionUID = -1582186294983391157L;
    @TableId(type = IdType.AUTO)
    Integer id;
    String name;    // 资源名称
    String url;     // 跳转的地址
    String path;     // 路由地址
    Integer pid;    // 上级资源ID
    Integer sort;   // 排序
    String icon;    // 图标
    Integer type;    // 资源类型 1-模块，2-页面，3-功能
    String component; // 前端页面
    Boolean state; // 展示状态
    Boolean menu; // 是否菜单
}
