package cn.tworice.system.service.login;



import cn.tworice.captcha.core.CaptchaBase64;
import cn.tworice.system.controller.login.vo.RegVO;
import cn.tworice.system.dao.resource.po.ResourcesDto;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.controller.login.vo.LoginVO;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.dao.role.po.RoleDO;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface LoginService {

    CaptchaBase64 getLoginCaptcha(HttpServletRequest request, String code);

    String getRegCaptcha(String email);

    String getCaptcha(String email);

    RequestResult checkMailCaptchaLogin(LoginVO loginVO, HttpServletRequest request);

    RequestResult checkLogin(LoginVO loginVO, HttpServletRequest request);

    RequestResult checkLogin(String key, String varCode,HttpServletRequest request);

    String checkReg(RegVO regVO);

    RequestResult loginSuccess(UserDO user);

    UserDO existUser(LoginVO loginVO);

    List<ResourcesDto> getResourceByRole(String userId);

    List<ResourcesDto> getResourcesAll(String userId);

    List<RoleDO> getRolesById(String id);


    UserDO getUserByLoginName(String loginName);

    boolean setUserAndRole(UserDO user, int roleId);

    void saveAdminResources(String userId, List<ResourcesDto> list);

    void sendReAuthCaptcha(String key);
}
