package cn.tworice.system.service.resources;



import cn.tworice.system.dao.resource.po.ResourcesDto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统缓存
 **/
public class CacheConst {
    /* 用户ID-角色列表 */
    public static final Map<String, List<Integer>> ROLES = new HashMap<>();

    /* 用户ID-资源列表 */
    public static final Map<String, List<ResourcesDto>> RESOURCES = new HashMap<>();

    /**
     * 清理用户列表所对应的资源列表
     * @param ids 用户ID数组
     **/
    public static void clearResources(String[] ids) {
        for (String id : ids) {
            CacheConst.RESOURCES.remove(id);
        }
    }

    /**
     * 清理用户列表所对应的角色列表
     * @param ids 用户ID数组
     **/
    public static void clearRoles(String[] ids) {
        for (String id : ids) {
            CacheConst.ROLES.remove(id);
        }
    }
}
