package cn.tworice.system.service.whiteList;

import cn.tworice.common.util.RequestUtil;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.whiteList.SystemWhiteListDao;
import cn.tworice.system.dao.whiteList.po.SystemWhiteListDO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class SystemWhiteListService implements InductsListenerService<SystemWhiteListDO> {
    @Resource
    private SystemWhiteListDao dao;

    public static List<SystemWhiteListDO> cache;

    /**
     * 核验当前IP是否在白名单中，如不在白名单中则直接报错
     * 如果需要限制登录IP白名单只需要调用此方法即可，无需对返回值进行处理
     **/
    public boolean ipVerify(){
        String ipAddr = IpAddrUtils.getIpAddr(RequestUtil.getHttpServletRequest());
        if("127.0.0.1".equals(ipAddr)) return true;
        if (SystemWhiteListService.cache == null) {
            SystemWhiteListService.cache = dao.selectList();
        }
        if (SystemWhiteListService.cache.isEmpty()) {
            throw new RuntimeException("当前系统未允许任何IP访问");
        }
        for (SystemWhiteListDO whiteList : SystemWhiteListService.cache) {
            if (IpAddrUtils.IPToLong(whiteList.getBeginIp()) <= IpAddrUtils.IPToLong(ipAddr) && IpAddrUtils.IPToLong(ipAddr) <= IpAddrUtils.IPToLong(whiteList.getEndIp())) {
                return true;
            }
        }
        throw new RuntimeException("当前IP未被允许访问系统");
    }


    public Map<String,Object> list(PageParam pageParam, SystemWhiteListDO entity) {
        return dao.selectPage(pageParam, new LambdaQueryWrapperX<SystemWhiteListDO>()
                .eqIfPresent(SystemWhiteListDO::getState, entity.getState())
                .eqIfPresent(SystemWhiteListDO::getBeginIp, entity.getBeginIp())
                .eqIfPresent(SystemWhiteListDO::getEndIp, entity.getEndIp())
        );
    }

    public int set(SystemWhiteListDO entity) {
        SystemWhiteListService.cache = null;
        entity.setUpdateTime(System.currentTimeMillis());
        if (entity.getId() == null) {
            entity.setCreateTime(System.currentTimeMillis());
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public boolean update(SystemWhiteListDO entity) {
        SystemWhiteListService.cache = null;
        return dao.updateById(entity) == 1;
    }

    public int del(Integer[] ids) {
        SystemWhiteListService.cache = null;
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    @Override
    public boolean saveBatch(List<SystemWhiteListDO> list) {
        SystemWhiteListService.cache = null;
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
            item.setUpdateTime(System.currentTimeMillis());
        });
        return dao.insertBatch(list,list.size());
    }

    public SystemWhiteListDO info(int id) {
        return dao.selectById(id);
    }
}