/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.login;

import cn.tworice.auth.config.AuthProperties;
import cn.tworice.auth.service.AuthManager;
import cn.tworice.auth.service.VerifyManger;
import cn.tworice.auth.util.TokenUtils;
import cn.tworice.captcha.core.CaptchaBase64;
import cn.tworice.common.framework.mail.core.MailExecutor;
import cn.tworice.common.util.AgingMap;
import cn.tworice.common.util.MathUtils;
import cn.tworice.common.util.NetworkUtil;
import cn.tworice.common.util.RegularTable;
import cn.tworice.common.util.StringUtils;
import cn.tworice.common.util.cryption.MD5Utils;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.ip.util.IpAddrUtils;
import cn.tworice.ip.util.UAUtil;
import cn.tworice.log.dao.po.LoginLogDO;
import cn.tworice.log.service.LogService;
import cn.tworice.system.conifg.LoginProperties;
import cn.tworice.system.controller.login.constand.LoginStateConst;
import cn.tworice.system.controller.login.constand.SuperAdminConst;
import cn.tworice.system.controller.login.vo.LoginVO;
import cn.tworice.system.controller.login.vo.RegVO;
import cn.tworice.system.controller.resources.vo.ResourceResult;
import cn.tworice.system.dao.resource.po.ResourcesDto;
import cn.tworice.system.dao.role.po.RoleDO;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.exception.LoginException;
import cn.tworice.system.service.login.LoginService;
import cn.tworice.system.service.resources.CacheConst;
import cn.tworice.system.service.resources.ResourcesService;
import cn.tworice.system.service.role.RoleService;
import cn.tworice.system.service.user.UserService;
import cn.tworice.system.service.user.UserStatusConst;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Resource
    private VerifyManger verifyManger;
    @Resource
    private AuthManager authManager;
    @Resource
    private LogService logService;
    @Resource
    private AgingMap<String, Object> agingMap;
    @Resource
    private MailExecutor mailUtil;
    @Resource
    private UserService userService;
    @Resource
    private RoleService roleService;
    @Resource
    private ResourcesService resourcesService;
    @Resource
    private LoginProperties loginProperties;
    private AgingMap<String, Object> reAuthAgingMap;
    @Resource
    private AuthProperties authProperties;
    @Resource
    private MailExecutor mailExecutor;

    @Override
    public CaptchaBase64 getLoginCaptcha(HttpServletRequest request, String code) {
        String clientIP = NetworkUtil.getClientIP((HttpServletRequest)request);
        if (code != null) {
            this.agingMap.remove((Object)code);
        }
        CaptchaBase64 captcha = new CaptchaBase64(this.loginProperties.getCaptchaType());
        captcha.setKey(StringUtils.generateUuid());
        if (this.agingMap.put((Object)captcha.getKey(), (Object)captcha.getResult().toLowerCase(), this.loginProperties.getCaptchaAging()) == null) {
            if (this.loginProperties.getExceeded().booleanValue() && this.authProperties.getMailBlast() != null) {
                this.mailExecutor.sendMail(this.authProperties.getMailBlast(), "\u68c0\u6d4b\u5230\u6076\u610f\u767b\u5f55\u8bf7\u6c42", "IP\u5730\u5740\uff1a" + clientIP + "\uff0c\u68c0\u6d4b\u5230\u5ba2\u6237\u7aef\u9891\u7e41\u8bf7\u6c42\u767b\u5f55\u9a8c\u8bc1\u7801");
            }
            throw new LoginException("\u9a8c\u8bc1\u7801\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return captcha;
    }

    @Override
    public String getRegCaptcha(String email) {
        String verCode;
        String key = StringUtils.generateUuid();
        if (this.agingMap.put((Object)key, (Object)(verCode = this.mailUtil.sendEmailCaptcha(4, email, "\u6ce8\u518c")), this.loginProperties.getCaptchaAging()) == null) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u8bf7\u6c42\u9891\u7e41\uff0c\u4e94\u5206\u949f\u540e\u518d\u8bd5");
        }
        log.debug("\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u3002key-{}\uff0ccode-{}", (Object)key, (Object)verCode);
        return key;
    }

    @Override
    public String getCaptcha(String email) {
        UserDO userDO = this.userService.existUserByEmail(email);
        if (userDO == null) {
            throw new LoginException("\u90ae\u7bb1\u4e0d\u5b58\u5728");
        }
        String verCode = this.mailUtil.sendEmailCaptcha(4, email, "\u9a8c\u8bc1\u7801");
        if (this.agingMap.put((Object)email, (Object)verCode, this.loginProperties.getCaptchaAging()) == null) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u8bf7\u6c42\u9891\u7e41\uff0c\u4e94\u5206\u949f\u540e\u518d\u8bd5");
        }
        log.debug("\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u3002email-{}\uff0ccode-{}", (Object)email, (Object)verCode);
        return email;
    }

    @Override
    public RequestResult checkMailCaptchaLogin(LoginVO loginVO, HttpServletRequest request) {
        if (!this.agingMap.exist((Object)loginVO.getLoginName(), (Object)loginVO.getCaptcha())) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.agingMap.remove((Object)loginVO.getLoginName());
        UserDO userDO = this.userService.existUserByEmail(loginVO.getLoginName());
        return this.loginSuccess(userDO, this.getRolesById(userDO.getId()));
    }

    @Override
    public RequestResult checkLogin(LoginVO loginVO, HttpServletRequest request) {
        this.verifyCaptcha(loginVO);
        if (this.isSuperAdmin(loginVO)) {
            return this.returnSuperAdminResult();
        }
        UserDO user = this.verifyLogin(loginVO, request);
        if (Objects.isNull(user)) {
            throw new LoginException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u6709\u8bef");
        }
        if (UserStatusConst.BAN.equals(user.getStatus())) {
            this.saveLog(loginVO, LoginStateConst.LOGIN_FAIL, request);
            throw new LoginException("\u8d26\u6237\u5df2\u88ab\u505c\u7528");
        }
        if (this.loginProperties.getReAuth().booleanValue() && !StringUtils.isEmpty((String)user.getEmail()) && RegularTable.EMAIL.verify(user.getEmail())) {
            this.saveLog(loginVO, LoginStateConst.LOGIN_SUCCESS, request);
            return this.buildReAuth(user);
        }
        this.saveLog(loginVO, LoginStateConst.LOGIN_SUCCESS, request);
        return this.loginSuccess(user, this.getRolesById(user.getId()));
    }

    @Override
    public RequestResult checkLogin(String key, String varCode, HttpServletRequest request) {
        if (!this.reAuthAgingMap.exist((Object)key, (Object)varCode)) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.reAuthAgingMap.remove((Object)key);
        return this.loginSuccess(this.userService.getInfo(key), this.getRolesById(key));
    }

    @Override
    public String checkReg(RegVO regVO) {
        Integer roleId = this.verifyRegRoleId(regVO.getRoleId());
        this.verifyRegCaptcha(regVO.getKey(), regVO.getCaptcha());
        UserDO userDO = this.verifyReg(regVO);
        if (userDO == null) {
            if (this.setUserAndRole(this.getUserDOByRegVO(regVO), roleId)) {
                return "\u6ce8\u518c\u6210\u529f";
            }
            throw new LoginException("\u6ce8\u518c\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5");
        }
        this.userService.updatePwd(userDO.getId(), regVO.getPassWord());
        return "\u8d26\u53f7\u5bc6\u7801\u5df2\u66f4\u65b0";
    }

    @Override
    public RequestResult loginSuccess(UserDO user) {
        return this.loginSuccess(user, this.getRolesById(user.getId()));
    }

    @Override
    public UserDO existUser(LoginVO loginVO) {
        return this.userService.getUserByEmailAndPwd(loginVO.getLoginName(), loginVO.getPassword());
    }

    @Override
    public List<ResourcesDto> getResourceByRole(String userId) {
        List<ResourcesDto> resources = CacheConst.RESOURCES.get(userId);
        if (resources != null) {
            return resources;
        }
        List<Integer> roles = CacheConst.ROLES.get(userId);
        if (roles == null || roles.isEmpty()) {
            roles = this.roleService.getRoleIdsByUid(userId);
            CacheConst.ROLES.put(userId, roles);
        }
        if (roles == null || roles.isEmpty()) {
            return null;
        }
        List<ResourcesDto> resourcesDtosA = this.resourcesService.selectResourcesByRoles(roles);
        for (ResourcesDto resourcesDto : resourcesDtosA) {
            ResourceResult result;
            if (resources == null) {
                resources = new ArrayList<ResourcesDto>();
            }
            if ((result = this.inResources(resources, resourcesDto)).getStatus().booleanValue()) {
                resources = result.getResult();
                continue;
            }
            resources.add(this.getParent(resourcesDto));
        }
        CacheConst.RESOURCES.put(userId, resources);
        return resources;
    }

    @Override
    public List<ResourcesDto> getResourcesAll(String userId) {
        List<ResourcesDto> resourcesDtos = CacheConst.RESOURCES.get(userId);
        if (resourcesDtos != null) {
            return resourcesDtos;
        }
        resourcesDtos = this.resourcesService.queryResourceAll();
        for (ResourcesDto dto : resourcesDtos) {
            List<ResourcesDto> resourcesDtos1 = this.getResourceByPid(dto.getId());
            for (ResourcesDto dto1 : resourcesDtos1) {
                dto1.setChildren(this.getResourceByPid(dto1.getId()));
            }
            dto.setChildren(resourcesDtos1);
        }
        CacheConst.RESOURCES.put(userId, resourcesDtos);
        return resourcesDtos;
    }

    @Override
    public List<RoleDO> getRolesById(String id) {
        return this.roleService.getRoleListByUid(id);
    }

    @Override
    public UserDO getUserByLoginName(String loginName) {
        return this.userService.getUser(loginName);
    }

    @Override
    public boolean setUserAndRole(UserDO user, int roleId) {
        if (StringUtils.isBlank((String)this.userService.updateOrInsert(user))) {
            return this.roleService.addUserToRole(new String[]{user.getId()}, roleId);
        }
        return false;
    }

    @Override
    public void saveAdminResources(String userId, List<ResourcesDto> list) {
        if (list == null || list.isEmpty() || userId.isEmpty()) {
            this.verifyManger.addAdminResources(userId, new String[0]);
        } else {
            ArrayList<String> urls = new ArrayList<String>();
            this.layer(list, urls);
            this.verifyManger.addAdminResources(userId, urls.toArray(new String[30]));
        }
    }

    @Override
    public void sendReAuthCaptcha(String key) {
        String randomNumber = MathUtils.getRandomNumber((int)6);
        if (this.reAuthAgingMap.put((Object)key, (Object)randomNumber, this.loginProperties.getCaptchaAging()) == null) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u8bf7\u6c42\u9891\u7e41\uff0c\u4e94\u5206\u949f\u540e\u518d\u8bd5");
        }
        try {
            this.mailUtil.sendMail(this.userService.getInfo(key).getEmail(), "\u90ae\u7bb1\u9a8c\u8bc1", "\u60a8\u7684\u9a8c\u8bc1\u7801:" + randomNumber);
        }
        catch (Exception e) {
            this.reAuthAgingMap.remove((Object)key);
            throw e;
        }
    }

    public List<ResourcesDto> getResourceByPid(Integer pid) {
        return this.resourcesService.selectResourcesByPid(pid);
    }

    public void verifyCaptcha(LoginVO loginVO) {
        if (loginVO.getCaptcha() == null || !this.agingMap.exist((Object)loginVO.getKey(), (Object)loginVO.getCaptcha().toLowerCase())) {
            throw new LoginException("\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8d85\u65f6");
        }
        this.agingMap.remove((Object)loginVO.getKey());
    }

    private ResourceResult inResources(List<ResourcesDto> resources, ResourcesDto resourcesA) {
        boolean mySwitch = false;
        for (ResourcesDto resourcesDto : resources) {
            ResourceResult map;
            if (resourcesDto.getId().equals(resourcesA.getPid())) {
                List<ResourcesDto> list = resourcesDto.getChildren();
                if (list == null) {
                    list = new ArrayList<ResourcesDto>();
                }
                list.add(resourcesA);
                resourcesDto.setChildren(list);
                ResourceResult resourceResult = new ResourceResult();
                resourceResult.setStatus(true);
                resourceResult.setResult(resources);
                return resourceResult;
            }
            if (resourcesDto.getChildren() == null || resourcesDto.getChildren().isEmpty() || !(map = this.inResources(resourcesDto.getChildren(), resourcesA)).getStatus().booleanValue()) continue;
            mySwitch = true;
        }
        ResourceResult resourceResult = new ResourceResult();
        resourceResult.setStatus(mySwitch);
        resourceResult.setResult(resources);
        return resourceResult;
    }

    private ResourcesDto getParent(ResourcesDto resourcesDto) {
        if (resourcesDto.getPid() == 0) {
            return resourcesDto;
        }
        ResourcesDto resourcesDtoA = this.resourcesService.selectResourcesDtoById(resourcesDto.getPid());
        ArrayList<ResourcesDto> list = new ArrayList<ResourcesDto>();
        list.add(resourcesDto);
        resourcesDtoA.setChildren(list);
        resourcesDto = resourcesDtoA;
        return this.getParent(resourcesDto);
    }

    private synchronized void layer(List<ResourcesDto> list, List<String> urls) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ResourcesDto resourcesDto : list) {
            if (StringUtils.isEmpty((String)resourcesDto.getUrl())) {
                urls.add(resourcesDto.getUrl());
            }
            this.layer(resourcesDto.getChildren(), urls);
        }
    }

    private UserDO buildSuperAdmin() {
        UserDO user = new UserDO();
        user.setId("1");
        user.setNickName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        return user;
    }

    private RoleDO buildSuperRole() {
        RoleDO role = new RoleDO();
        role.setId(SuperAdminConst.Super_Role_ID);
        role.setRoleName("\u8d85\u7ea7\u7ba1\u7406");
        return role;
    }

    public RequestResult loginSuccess(UserDO user, List<RoleDO> roles) {
        List<ResourcesDto> resources;
        if (user == null) {
            return RequestResult.error((Integer)400, (String)"\u767b\u5f55\u5f02\u5e38");
        }
        String token = TokenUtils.getAdminToken((String)user.getId(), (Long)this.loginProperties.getTokenTimeout());
        List<ResourcesDto> list = resources = "1".equals(user.getId()) ? this.getResourcesAll(user.getId()) : this.getResourceByRole(user.getId());
        if (resources == null) {
            throw new LoginException("\u5f53\u524d\u8d26\u53f7\u65e0\u4efb\u4f55\u6743\u9650");
        }
        this.saveAdminResources(user.getId(), resources);
        this.verifyManger.online(user.getId(), token);
        return RequestResult.success((String)"\u767b\u5f55\u6210\u529f").appendData("token", (Object)token).appendData("admin", (Object)user).appendData("resources", resources).appendData("roles", roles);
    }

    private void saveLog(LoginVO loginVO, Integer state, HttpServletRequest request) {
        this.logService.addLoginLog(new LoginLogDO().setLoginName(loginVO.getLoginName()).setPassWord(MD5Utils.getMd5Plus((String)loginVO.getPassword())).setStatus(state).setIpAddr(IpAddrUtils.getIpAddr((HttpServletRequest)request)).setActive(UAUtil.getDevice((HttpServletRequest)request)));
    }

    private boolean isSuperAdmin(LoginVO loginVO) {
        return (loginVO.getLoginName() + "-" + loginVO.getPassword()).equals(this.loginProperties.getRoot());
    }

    private RequestResult returnSuperAdminResult() {
        UserDO user = this.buildSuperAdmin();
        ArrayList<RoleDO> roles = new ArrayList<RoleDO>();
        roles.add(this.buildSuperRole());
        return this.loginSuccess(user, roles);
    }

    private RequestResult buildReAuth(UserDO user) {
        if (this.reAuthAgingMap == null) {
            this.reAuthAgingMap = new AgingMap();
        }
        this.sendReAuthCaptcha(user.getId());
        return RequestResult.success().appendData("key", (Object)user.getId()).appendData("reAuth", (Object)true);
    }

    private Integer verifyRegRoleId(Integer roleId) {
        if (roleId == null) {
            return this.loginProperties.getDefaultRoleId();
        }
        if (!this.loginProperties.getAllowRole().contains(roleId)) {
            throw new LoginException("\u975e\u6cd5\u89d2\u8272");
        }
        return roleId;
    }

    private void verifyRegCaptcha(String key, String captcha) {
        if (!this.agingMap.exist((Object)key, (Object)captcha)) {
            this.agingMap.remove((Object)key);
            throw new LoginException("\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8d85\u65f6");
        }
    }

    private UserDO getUserDOByRegVO(RegVO regVO) {
        UserDO user = new UserDO();
        user.setLoginName(regVO.getEmail() != null ? regVO.getEmail() : regVO.getPhone());
        user.setEmail(regVO.getEmail());
        user.setPhone(regVO.getPhone());
        user.setPassWord(regVO.getPassWord());
        user.setNickName(regVO.getNickName());
        user.setInviterId(this.userService.getUserIdByInviteCode(regVO.getInvitationCode()));
        return user;
    }

    private UserDO verifyReg(RegVO regVO) {
        switch (regVO.getRegModel()) {
            case EMAIL: {
                return this.userService.existUserByEmail(regVO.getEmail());
            }
            case PHONE: {
                return this.userService.existUserByPhone(regVO.getPhone());
            }
        }
        return null;
    }

    private UserDO verifyLogin(LoginVO loginVO, HttpServletRequest request) {
        UserDO userDO = null;
        switch (loginVO.getLoginModel()) {
            case LOGIN_NAME: {
                userDO = this.userService.getUserByNameAndPwd(loginVO.getLoginName(), loginVO.getPassword());
                if (userDO != null) break;
                this.loginFail(loginVO, request, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
                break;
            }
            case EMAIL: {
                userDO = this.userService.getUserByEmailAndPwd(loginVO.getLoginName(), loginVO.getPassword());
                if (userDO != null) break;
                this.loginFail(loginVO, request, "\u90ae\u7bb1\u6216\u5bc6\u7801\u9519\u8bef");
                break;
            }
            case PHONE: {
                userDO = this.userService.getUserByPhoneAndPwd(loginVO.getLoginName(), loginVO.getPassword());
                if (userDO != null) break;
                this.loginFail(loginVO, request, "\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
                break;
            }
            case ID: {
                userDO = this.userService.getUserByIDAndPwd(loginVO.getLoginName(), loginVO.getPassword());
                if (userDO != null) break;
                this.loginFail(loginVO, request, "\u552f\u4e00\u6807\u8bc6\u6216\u5bc6\u7801\u9519\u8bef");
                break;
            }
            default: {
                throw new LoginException("\u767b\u5f55\u65b9\u5f0f\u5f02\u5e38");
            }
        }
        return userDO;
    }

    private void loginFail(LoginVO loginVO, HttpServletRequest request, String failTips) {
        this.saveLog(loginVO, LoginStateConst.LOGIN_FAIL, request);
        this.authManager.record(request);
        throw new LoginException(failTips);
    }
}

