package cn.tworice.system.conifg;

import cn.tworice.common.util.AgingMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

@Configuration
public class SystemConfig implements WebMvcConfigurer {

    @Resource
    private LoginProperties loginProperties;

    /**
     * 放行静态文件
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
    }

    /**
     * 注入一个AgingMap
     */
    @Bean
    public AgingMap<String,Object> addAgingMap(){
        return new AgingMap<String,Object>(loginProperties.getLimit());
    }
}
